#!/usr/local/bin/perl 

#to be run in the gramene_ensembl directory

use strict;
use warnings;

use lib qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use Getopt::Std;
use DBI;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;

use vars qw/ $opt_a $opt_s $opt_i/;

getopts('a:s:i:') or die("-a [-s] [-i] only\n");

my $analysis=$opt_a;
$analysis=~ /^\d+$/ or die 'analysis must be a number';

my $score=$opt_s || 110;
$score=~ /^\d+$/ or die 'score must be a number';

my @ignore=split /,/,$opt_i;
grep { $_=~/\D/ } @ignore and die '-i args are column numbers(0...) to ignore';



    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";

my $feature_id;
{
my $sth;
($sth=$db->prepare("select max(id) from feature")) and $sth->execute 
					    or die "feature id:".$db->errstr;
($feature_id)=$sth->fetchrow_array or die "feature id:".$db->errstr;
$feature_id ||=0;
}

my $ff_rank=1;	#don't know what it does

$|=1;

while(<>) {
    tr/\r//d;
    chomp; 
    next if /^#/;
                                                                    

    my @F=split /\t/;
    foreach my $col (@ignore) { splice @F,$col,1; }

    my($feature_acc,$feature_start,$feature_stop
      ,$contig_name,$version,$ctg_start,$ctg_stop
      ,$perc)=@F;

    $ctg_stop =~/\d/ && $ctg_start =~/\d/ or print STDERR "?:$_\n" and next;

    #These are all offsets, so change to start=1:
    $ctg_start++; $ctg_stop++; $feature_start++; $feature_stop++;

    #Make sure they are start, end wrt BAC:
    ($ctg_start,$ctg_stop,$feature_start,$feature_stop)=
    ($ctg_stop,$ctg_start,$feature_stop,$feature_start) if($ctg_start>$ctg_stop);

    defined (my $contig=contig_id($contig_name,$version)) or next;
    
    add($contig,$ctg_start,$ctg_stop,
	    ,$feature_acc,$feature_start,$feature_stop
	    ,$perc);
}
 

sub add {
my($contig,$ctgstart,$ctgstop,
	    ,$feature_acc,$feature_start,$feature_stop
	    ,$perc)=@_;
    $db->do(
        "insert into feature (id,contig,seq_start,seq_end,score,strand
	                     ,analysis,name,hstart,hend,hid,perc_id)
			values (?,?,?,?,$score,1
			      ,$analysis,?,?,?,?,?)"
		       
	,undef,  ++$feature_id,$contig,$ctgstart,$ctgstop,
		 ,$feature_acc,$feature_start,$feature_stop,$feature_acc
		 ,$perc
	)
		or die "insert feature".$db->errstr;
}




sub contig_id {
my($contig,$version)=@_;
my $sth;
    ($sth=$db->prepare("select contig.internal_id,clone.version from contig,clone where contig.id='$contig' and contig.clone=clone.internal_id")) and $sth->execute 
					    or die "Contig $contig:".$db->errstr;
    my($id,$dbversion)=$sth->fetchrow_array or print STDERR "Contig $contig:".$db->errstr."\n" and return undef;

    $dbversion eq $version or print "Contig $contig: want version $version. Database has version $dbversion\n";
    return $id;
}
