#!/usr/local/bin/perl 

#to be run in the gramene_ensembl directory

use strict;
use warnings;

use lib qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use DBI;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;


    #my $ENSEMBL_ORACLE_HOME='/oracle1/app/oracle/product/8.1.7';
    #my $ENSEMBL_TWO_TASK='P:rice';
    #my $ENSEMBL_TWO_TASK='T:localhost:rice';
    #$ENV{ORACLE_HOME} = $ENSEMBL_ORACLE_HOME if ($ENSEMBL_ORACLE_HOME) ;
    #$ENV{TWO_TASK} = $ENSEMBL_TWO_TASK if ($ENSEMBL_TWO_TASK) ;
    #$ENV{ORA_PIPES} = "V2";
    #$ENV{TNS_ADMIN}=$ENSEMBL_ORACLE_HOME.'/network/admin';

    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";

my $feature_id;
{
my $sth;
($sth=$db->prepare("select max(id) from feature")) and $sth->execute 
					    or die "feature id:".$db->errstr;
($feature_id)=$sth->fetchrow_array or die "feature id:".$db->errstr;
$feature_id ||=0;
}

$|=1;

while(<>) {
    tr/\r//d;
    chomp; 
    next if /^#/;
    my($bac_end_accession,$end_start,$end_stop
      ,$bac_accession,$version,$bac_start,$bac_stop
      ,$perc)=split /\t/;

    $bac_stop =~/\d/ && $bac_start =~/\d/ or print STDERR "?:$_\n" and next;

    my $our_version;
    eval {
        $our_version= $db->get_Clone($bac_accession)->version;
    };
    $@ and print "$@\n" and next;
    print "BAC version should be $our_version:$_\n" and next if $our_version ne $version;

    #These are all offsets, so change to start=1:
    $bac_start++; $bac_stop++; $end_start++; $end_stop++;

    #Make sure they are start, end wrt BAC:
    ($bac_start,$bac_stop,$end_start,$end_stop)=
    ($bac_stop,$bac_start,$end_stop,$end_start) if($bac_start>$bac_stop);

    my($contig1,$ctgpos1,$ctglen1, $contig2,$ctgpos2,$ctglen2);
    eval {
	($contig1,$ctgpos1,$ctglen1)=$db->clone_to_contig($bac_accession,$bac_start);
	($contig2,$ctgpos2,$ctglen2)=$db->clone_to_contig($bac_accession,$bac_stop);
    };
    $@ and print "$@\n" and next;
    #print "$bac_accession: $bac_start -> $contig1,$ctgpos1;  $bac_stop -> $contig2,$ctgpos2\n";
    if(!$contig1 && ! $contig2) {
	print "$bac_end_accession, $bac_accession, $bac_start -> nowhere, $bac_stop -> nowhere\n";
    } elsif($contig1 && ! $contig2) {
	print "$bac_end_accession, $bac_accession, $bac_start -> $contig1,$ctgpos1, $bac_stop -> nowhere\n";
        add($contig1,$ctgpos1,$ctglen1
	   ,$bac_end_accession,$bac_start
	   ,($bac_start<$bac_stop)?($bac_start+$ctglen1-$ctgpos1)
				 :($bac_start-$ctglen1+$ctgpos1)
	   ,$perc);
    } elsif($contig2 && ! $contig1) {
	print "$bac_end_accession, $bac_accession, $bac_start -> nowhere, $bac_stop -> $contig2,$ctgpos2\n";
        add($contig2,1,$ctgpos2
	   ,$bac_end_accession
	   ,($bac_start<$bac_stop)?($bac_stop+1-$ctgpos2)
				 :($bac_stop-1+$ctgpos2)
	   ,$bac_stop
	   ,$perc);
    } elsif($contig1==$contig2) {
        add($contig1,$ctgpos1,$ctgpos2,
	    ,$bac_end_accession,$end_start,$end_stop
	    ,$perc);
    } else {  #yes this assumes the BAC end does not include a whole contig
           # and the perc's may not be true (maybe should use fset)
	print "$bac_end_accession, $bac_accession, $bac_start -> $contig1,$ctgpos1, $bac_stop -> $contig2,$ctgpos2\n";
        add($contig1,$ctgpos1,$ctglen1
	   ,$bac_end_accession,$bac_start
	   ,($bac_start<$bac_stop)?($bac_start+$ctglen1-$ctgpos1)
				 :($bac_start-$ctglen1+$ctgpos1)
	   ,$perc);
        add($contig2,1,$ctgpos2
	   ,$bac_end_accession
	   ,($bac_start<$bac_stop)?($bac_stop+1-$ctgpos2)
				 :($bac_stop-1+$ctgpos2)
	   ,$bac_stop
	   ,$perc);
    }
}
 

sub add {
my($contig,$ctgstart,$ctgstop,
	    ,$bac_end_accession,$end_start,$end_stop
	    ,$perc)=@_;
    $db->do(
        "insert into feature (id,contig,seq_start,seq_end,score,strand
	                     ,analysis,name,hstart,hend,hid,perc_id)
			values (?,?,?,?,110,1
			      ,602,?,?,?,?,?)"
		       
	,undef,  ++$feature_id,$contig,$ctgstart,$ctgstop,
		 ,$bac_end_accession,$end_start,$end_stop,$bac_end_accession
		 ,$perc
	)
		or die "insert".$db->errstr;
}
