#!/usr/local/bin/perl 

#to be run in the gramene_ensembl directory

use strict;
use warnings;

my @lib;
BEGIN {	#find libraries somewhere above us
    my @wantlib=qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );
    @lib=();
    my $dir='.';
    my $slast='';
    while(-d $dir and @wantlib) {
	my $s=join(":",(stat $dir)[0,1]);	#need this because .. of root dir is root
	last if $s eq $slast;
	$slast=$s;
	#print "$dir $s\n";
	foreach (@wantlib) {
	    if( -d "$dir/$_") { push @lib,"$dir/$_"; $_=''; }
	}
	@wantlib=grep { $_ } @wantlib;
	$dir="../$dir";
    }
    #print join (" + ",@lib),"\n";
    die "Can't find ",join(" or ",@wantlib)," in parent directories" if @wantlib;
}
use lib (@lib);

use DBI;
use LWP;
use CGI;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;

my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";

my $agent=LWP::UserAgent->new;

open ALLHELP,">allhelp.html" or die "allhelp.html:$!";

print ALLHELP "<html><head><title>all of helpview</title></head>\n<body>\n";

while(<>) {
    chomp;
    my($kw,$title,$content)=split /\t/;
    $kw or next;
    $content or print STDERR "?$_\n" and next;
    if($content =~ /^\<\<(.+)/ ) {
        $content=read_until($1);
    } elsif ( $content =~ /\@file:(.+)/) {
        $content=readfile($1);
    } elsif ( $content =~ /\@(.+)/ ) {
        $content=get($1);
    } else {
        print STDERR "?$_\n";
	next;
    }
    set_help($kw,$title,$content) unless $kw=~/^!/;
}

print ALLHELP "</body></html>\n";

sub read_until {
my($marker)=(shift() )."\n";
my $ret='';
    while(<>) {
        $_ eq $marker and last;
	$ret.=$_;
    }
    return $ret;
}

sub readfile {
my($infile)=@_;
    open INFILE,$infile or print STDERR "$infile:$!\n" and return '';
    my $ret=(<INFILE>);
    close INFILE;
    return $ret;
}

sub get {
    my($url)=@_;

    my $request=HTTP::Request->new(GET=>$url);
    my $response=$agent->request($request);
    if(!$response->is_success ) { print STDERR "$url failed: ",$response->message,"\n" ; return ''; }
    my $content=$response->content; 
    $content =~ s!.*</head>!!is;
    $content =~ s!.*<body[^>]*>!!is;
    $content =~ s@.*<!-- helpview start -->@@is;
    $content =~ s!</body.*!!is; 
    $content =~ s@<!-- helpview end -->.*@@is;
    if($url =~ m!^http://[^/]*(/.*)! ) {
	my $here=$1;
	$here =~ s![^/]+$!!;
	print STDERR "$here\n";
	$content =~ s{href="(?!mailto:)(?!http://)(?!ftp://)([^/])}{href="$here$1}ig;
    }
    $content =~ s{\b(href=)(?![^>]*target=)}{target="external" $1}ig;
    return $content;
    
}

sub set_help {
my($kw,$title,$content)=@_;
    print ALLHELP "<h1>",CGI::escapeHTML($title)," ($kw)</h1>\n$content\n";
    $db->do("delete from helpview where kw='$kw'") or die "delete:".$db->errstr;
    print STDERR "$kw $title ",length($content);
    my $piece=0;
    while(length($content)>4000) {
	my $cut=1+rindex($content,"\n",4000);
	$cut=4000 if($cut<=0 || $cut>4000) ;
	$db->do("insert into helpview (kw,title,content,piece) values('$kw',?,?,$piece)",undef,
	    $title,substr($content,0,$cut) ) or die "insert:".$db->errstr;
	$content=substr($content,$cut);
	$piece++;
    }
    $db->do("insert into helpview (kw,title,content,piece) values('$kw',?,?,$piece)",undef,
		$title,$content) or die "insert:".$db->errstr;
    print STDERR "=>",$piece+1,"\n";
}
