#!/usr/local/bin/perl 


use strict;
use warnings;

use lib map { $ENV{GrameneEnsemblDir}."/$_" } qw( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use DBI;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;


    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";


# In:
# #       #       MARKER_NAME,MARKER_ACCESSION,MARKER_START,MARKER_STOP,CONTIG.ID,CLONE.VERSION,CONTIG_START,CONTIG_STOP
# C1006   C98193  5       399     AP003807.001    1       48634   49285
# C1008   C98194  0       454     AP003838.004    1       12654   13104
# C1008   D22714  0       330     AP003838.004    1       12073   12637
# 
# Out:
# marker_name, marker_accession, marker_start, marker_stop, bac_accession, bac_version, bac_start, bac_stop, perc_identity

while(<>) {
    tr/\r//d;
    print and next if /^#/;
    chomp; 
    my($marker_name,$marker_acc,$marker_start,$marker_stop
      ,$contig,$clone_version,$contig_start,$contig_stop
      )=split /\t/;

    my($clone,$clone_start,$clone_stop)=contig_to_clone($contig,$clone_version,$contig_start,$contig_stop) or next;
    print "$marker_name\t$marker_acc\t$marker_start\t$marker_stop\t$clone\t$clone_version\t$clone_start\t$clone_stop\t100\n";

}
 

sub contig_to_clone {
my($contig,$version,@contig_posns)=@_;
my $sth;
($sth=$db->prepare("select clone.id,clone.version,contig.offset,contig.length from contig,clone where contig.id='$contig' and contig.clone=clone.internal_id")) and $sth->execute 
					    or die "Contig $contig:".$db->errstr;
my($clone,$dbversion,$offset,$length)=$sth->fetchrow_array or print STDERR "Can't fetch Contig $contig:".$db->errstr."\n" and return ();

$dbversion eq $version or print STDERR "Contig $contig: want version $version. Database has version $dbversion\n";
    my @retval=($clone);
    foreach my $x (@contig_posns) {
	$x<=$length or print STDERR "Contig $contig: Coordinate $x is too large (>$length)\n" and return ();
	push @retval,$x+$offset-1;
    }
    
    return @retval
}
