#!/usr/local/bin/perl 

#to be run in the gramene_ensembl directory

use strict;
use warnings;
use lib qw ( /export/share_more/ensembl/gramene_ensembl/bioperl-live /export/share_more/ensembl/gramene_ensembl/modules /export/share_more/ensembl/gramene_ensembl/ensembl/modules /export/share_more/ensembl/gramene_ensembl/ensembl-external/modules /export/share_more/ensembl/gramene_ensembl/lib/perl );


use DBI;
use IO::File;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;
use Getopt::Std;

my $db_login=SequenceName."/".SequencePass;

use constant EnsemblLocator =>'Bio::EnsEMBL::DBSQL::DBAdaptor/host=chevre.cshl.org;port=1521;dbname=gramene;user=riceseq1;pass=grain;perlonlyfeatures=0;mapdbname=;driver=Oracle;debug=0';

my $ctl_sql_dir="CTL_AND_SQL";

my ($feature_id,$analysis,$score,$sth,$sth_contigs,$db_fset_id,$ff_rank,$last_fset,$alignment_file,$feature_fh,$fset_fh,$fset_feature_fh);

my $USAGE="
Given a list of analysis_ids and the paths to the files with alignments for these id's, this script truncates all alignment tables and loads the file alignments using direct load from sqlloader.
Usage:
perl direct_load_all.pl -l list_analysis_and_files.\n\n";

my %option;
getopt('l',\%option);
unless (defined $option{l}) {die $USAGE};



my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";

my $list_file_fh=IO::File->new($option{l},O_RDONLY)
  or die "Couldn't open file $option{l} for reading: $!\n";

#  Truncate feature,fset_feature,fset, and marker_clone tables.
  make_temp_query($analysis,'truncate_all.sql');
  system("sqlplus $db_login \@$ctl_sql_dir/temporary.sql")==0 || die "Couldn't exec: $!"; 
  print "Cleared the marker_clone,feature,fset,and fset_feature tables\n";



while(defined($_=$list_file_fh->getline())) {
  chomp;
  s/ |\r//g;
  (my $type,$alignment_file,$analysis)=split '\t';
  if ($type eq 'feature'){
    make_table_files();
    load_tables();
  }
  elsif($type eq 'marker'){

  }
}
END{
  $sth->finish() if $sth;
  $sth_contigs->finish() if $sth_contigs;
  $db->disconnect() if $db;
  unlink("feature.dat"); 
  unlink("fset_feature.dat");
  unlink("fset.dat");
}

sub make_table_files{
  unlink("feature.dat"); 
  unlink("fset_feature.dat");
  unlink("fset.dat");
  $feature_fh=IO::File->new("feature.dat",O_RDWR|O_CREAT| O_EXCL)
  or die "Couldn't create and open feature.dat: $!\n";
  $fset_fh=IO::File->new("fset.dat",O_RDWR|O_CREAT | O_EXCL)
  or die "Couldn't create and open fset.dat: $!\n";
  $fset_feature_fh=IO::File->new("fset_feature.dat",O_RDWR|O_CREAT | O_EXCL)
    or die "Couldn't create and open fset_feature.dat: $!\n";
  
  my $input_file_fh=IO::File->new($alignment_file,O_RDONLY)
    or die "Couldn't open file $alignment_file for reading: $!\n";
  
  $analysis=~ /^\d+$/ or die 'analysis must be a number';
  
  $score=110;
  $score=~ /^\d+$/ or die 'score must be a number';
  

 
  
 $sth_contigs=$db->prepare("select contig.internal_id,clone.version from contig,clone where contig.id=? and contig.clone=clone.internal_id"); 

  {
    ($sth=$db->prepare("select max(id) from feature")) and $sth->execute 
      or die "feature id:".$db->errstr;
    ($feature_id)=$sth->fetchrow_array or die "feature id:".$db->errstr;
    $feature_id ||=0;
  }
  $db_fset_id=get_fset();
  
  $ff_rank=1;	#don't know what it does
  $last_fset=-1;	#better not be a real one!
  
  $|=1;
  
  while(defined($_=$input_file_fh->getline())) {
    tr/\r//d;
    chomp; 
    next if /^#/;
      my($fset_id,$feature_acc,$feature_start,$feature_stop
	 ,$contig_name,$version,$ctg_start,$ctg_stop
	 ,$perc)=split /\t/;
    
    $ctg_stop =~/\d/ && $ctg_start =~/\d/ or print STDERR "Couldn't get contig start and stop from line $.:$_\n" and next;
    
    if($fset_id != $last_fset) {
      $db_fset_id++;
      $last_fset=$fset_id;
      $ff_rank=1;
      print $fset_fh "$db_fset_id\t$score\n";
    }
    
  
  
    #These are all offsets, so change to start=1:
    $ctg_start++; $ctg_stop++; $feature_start++; $feature_stop++;
    
    #Make sure they are start, end wrt BAC:
    ($ctg_start,$ctg_stop,$feature_start,$feature_stop)=
      ($ctg_stop,$ctg_start,$feature_stop,$feature_start) if($ctg_start>$ctg_stop);
    
    defined (my $contig=contig_id($contig_name,$version)) or next;
    $@ and print "$@\n" and next;
    add($contig,$ctg_start,$ctg_stop,
	,$feature_acc,$feature_start,$feature_stop
	,$perc);
    
  }

    $feature_fh->close() if $feature_fh;
    $fset_feature_fh->close() if $fset_feature_fh;
    $fset_fh->close() if $fset_fh;
    $input_file_fh->close() if $input_file_fh;  
}


sub add {
  my($contig,$ctgstart,$ctgstop,
     ,$feature_acc,$feature_start,$feature_stop
     ,$perc)=@_;
  $feature_id++;
  print $feature_fh "$feature_id\t$contig\t$ctgstart\t$ctgstop\t$score\t1\t$analysis\t$feature_acc\t$feature_start\t$feature_stop\t$feature_acc\t$perc\n";
  print $fset_feature_fh "$feature_id\t$db_fset_id\t$ff_rank\n";
}

sub get_fset{
  my $sth;
  ($sth=$db->prepare("select max(id) from fset")) and $sth->execute 
    or die "fset id:".$db->errstr;
  my ($gotten_fset_id)=$sth->fetchrow_array or die "fset id:".$db->errstr;
  $gotten_fset_id ||=0;
  return $gotten_fset_id;
}



sub contig_id {
  my($contig,$version)=@_;
  $sth_contigs->execute($contig) or die "Contig $contig:".$db->errstr;
  my($id,$dbversion)=$sth_contigs->fetchrow_array or print STDERR "Contig $contig:".$db->errstr."\n" and return undef;
  
  $dbversion eq $version or print "Contig $contig: want version $version. Database has version $dbversion\n";
  return $id;
}

sub load_tables{
system("sqlldr $db_login control=$ctl_sql_dir/control_fset.ctl direct=true")==0 || die "Couldn't exec system call: $!"; 
system("sqlldr $db_login control=$ctl_sql_dir/control_feature.ctl direct=true")==0 || die "Couldn't exec system call: $!"; 
system("sqlldr $db_login control=$ctl_sql_dir/control_fset_feature.ctl direct=true")==0 || die "Couldn't exec system call: $!"; 
  
}

sub make_temp_query{
  my ($analysis,$query_name)=@_;
  open(QUERY_SQL,"$ctl_sql_dir/$query_name") or  die "Can't open the file: $!\n";
  undef $/;
  my $temp_query=<QUERY_SQL>;
  $temp_query=~s/{ANALYSIS}/$analysis/g;
  open(TEMP_SQL,">$ctl_sql_dir/temporary.sql") or  die "Can't open the file: $!\n";
  print TEMP_SQL $temp_query;
  close (TEMP_SQL) or die "Can't close the file $!\n";
  $/="\n";
}
