#!/lab/bin/perl

use strict;

=head1

convert sqlldr control file(s) to a
translate_and_dump.pl control file

=cut

my ($file,$table,$sep,@fields);


while(<>) {
    chomp;
    s/\bLOAD\s+DATA\b//i and oneline();
    s/\bINFILE\s*'([^']+)'//i and $file=$1;
    s/INTO TABLE\s+(\S+)//i and $table=$1;
    s/FIELDS TERMINATED BY\s+(\S+)// and $sep=$1;
    if( s/^\(// or s/^.*[^Xx]\(// ) {
	@fields = split /[^A-Za-z_0-9]+/;
	while(<>) {
	    push @fields , split /[^A-Za-z_0-9]+/;
	    last if /\)/;
	}
    }
}
oneline();

sub oneline {
    $file || $table || $sep || @fields or return;
    print "? " unless $file && $table && $sep && @fields;
    print "$file $sep $table ",join(" ",@fields),"\n";
}

#LOAD DATA
#INFILE 'exon_transcript.dat'
#DISCARDFILE 'exon_transcript.dis'
#APPEND
#INTO TABLE exon_transcript
#FIELDS TERMINATED BY ','
#(exon,
# transcript,
# rank
#)
