#!/opt/bin/perl -w

use strict;

use lib $ENV{'GrameneCodeDir'}."/lib/perl";

use DBI;
use DBD::Oracle qw(:ora_types);
use CSHL::Config;


my $user = SequenceDBUser;
my $passwd = SequenceDBPassword;
my $dbh = DBI->connect(SequenceDataSource,
                       $user, 
                       $passwd, 
		       {PrintError =>1,
			RaiseError =>1, 
                        AutoCommit =>0}) || die $DBI::errstr;;
$dbh->{LongReadLen} = 1000*65535;
$dbh->{LongTruncOk} = 0;
my $tableName = "dna";
my $columnList = "orcl_sequence, length, created";
open (INPUT, "dna.dat") || die "cannot open";
my ($sql, $sth, $line);
my $count = 0;  
while ($line = <INPUT> ){
   $count++;			
   chomp($line);
   my @values = split(/,/, $line);

   $sql = qq{INSERT INTO $tableName($columnList) VALUES (?, ?, ?)};
   $sth = $dbh->prepare($sql);
   $sth->bind_param(1, $values[0], {ora_type=>ORA_CLOB});
   $sth->bind_param(2, $values[1]);
   $sth->bind_param(3, $values[2]);
   $sth->execute();
   print "Record $count inserted\n";
}
$sth->finish;
$dbh->commit;
$dbh->disconnect;
