
### Bio::EnsEMBL::DBSQL::SQL::StatementHandle

package Bio::EnsEMBL::DBSQL::SQL::StatementHandle;

use strict;
use DBI;
use Bio::Root::RootI;
use Bio::EnsEMBL::DBSQL::SQL::Orowhash;
use vars '@ISA';

@ISA = qw{ DBI::st Bio::Root::RootI };


sub execute {
    my( $sth, @args ) = @_;
    
    #print STDERR "SQL::StatementHandle::execute\n";
    my $result = $sth->SUPER::execute(@args);
    if ($result) {
        return $result;
    } else {
        $sth->throw("execute failed : '$DBI::errstr'");
    }
}

sub fetchrow_hashref {
    my( $sth, @args ) = @_;
    my $p_hash = $sth->SUPER::fetchrow_hashref(@args);
    if($p_hash) {
	my %ohash;
	#print STDERR map {"$_=>".$p_hash->{$_}."\n"} keys %$p_hash;
	if(tie %ohash, "Bio::EnsEMBL::DBSQL::SQL::Orowhash") {
	    %ohash=(%$p_hash);
	    return \%ohash;
	} else {
	    $sth->throw("Can't tie to Orowhash");
	}
    } else {
	if($sth->err) {
	    $sth->throw("fetchrow_hashref failed : '$DBI::errstr'");
	    					# or $sth->errstr
	} else {	#simply no more selected rows:
	    return undef;
	}
    }
}

1;

__END__

=head1 NAME - Bio::EnsEMBL::DBSQL::SQL::StatementHandle

=head1 DESCRIPTION

This package inherits from B<DBI::st>, and
overrides its B<execute> function to provide nice
BioPerl style exceptions.

Also it overrides B<fetchrow_hashref> to return a
reference to an Orowhash, which is case_insensitive, etc.

=head1 AUTHOR

James Gilbert B<email> jgrg@sanger.ac.uk

