package Bio::EnsEMBL::DBSQL::SQL::Orowhash;
$VERSION = 1.01;
use strict;

# Slightly muddyfied from Insensitive::Hash in 
#     Damian Conway _Object_Oriented_Perl_
# Steven Schmidt, Cold Spring Harbor Laboratory, June 2001

sub TIEHASH
{
	my ($class) = @_;
	bless {}, $class;
}

sub FETCH
{
	my ($impl, $key) = @_;
	(my $lkey =lc $key)=~s/^ORCL_//;
	return $impl->{$lkey }{value};	
}

sub STORE
{
	my ($impl, $key, $newval) = @_;
	(my $lkey =lc $key)=~s/^ORCL_//;
	$impl->{$lkey} = {key=>$key, value=>$newval};	
	#print STDERR "$lkey($key)=>$newval\n";
}

sub EXISTS
{
	my ($impl, $key) = @_;
	(my $lkey =lc $key)=~s/^ORCL_//;
	return exists $impl->{$lkey};
}

sub DELETE
{
	my ($impl, $key) = @_;
	(my $lkey =lc $key)=~s/^ORCL_//;
	my $val = delete $impl->{$lkey};
	return $val->{value} if $val;
}

sub CLEAR
{
	my ($impl) = @_;
	%{$impl} = ();
}

sub FIRSTKEY
{
	my ($impl) = @_;
	keys %{$impl};
	my $first_key = each %{$impl};
	return undef unless defined $first_key;
	return $impl->{$first_key}->{key};
}

sub NEXTKEY
{
	my ($impl, $nextkey) = @_;
	my $next_key = each %{$impl};
	return undef unless defined $next_key;
	return $impl->{$next_key}->{key};
}



#########################################################################
#                                                                       #
#  Original Insensitive::Hash module                                    #
#  Copyright (C) 1999 by Manning Publications Co. All Rights Reserved.  #
#                                                                       #
#  This code is free software. It may be used, redistributed            #
#  and/or modified under the terms of the Perl Artistic License         #
#  (see http://www.perl.com/perl/misc/Artistic.html).                   #
#                                                                       #
#########################################################################

