
### Bio::EnsEMBL::DBSQL::SQL

package Bio::EnsEMBL::DBSQL::SQL;

use strict;
use DBI;
use Bio::EnsEMBL::DBSQL::SQL::mysql;
use Bio::EnsEMBL::DBSQL::SQL::oracle;
use Bio::EnsEMBL::DBSQL::SQL::sybase;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;
use Bio::Root::RootI;

use Carp qw(cluck);

use vars '@ISA';

@ISA = qw{ DBI::db Bio::Root::RootI };

sub new {
    my( $pkg, $dsn, $user, $password ) = @_;

    #print STDERR "BED::SQL->new($dsn,$user,$password,)\n";
    
    my $dbh = DBI->connect($dsn, $user, $password, {RaiseError => 0, PrintError => 1, LongReadLen => 1000000 });  # 16777215=length of MySQL MEDIUMTEXT is more than we need
    #print STDERR "after connect\n";
    if ($dbh) {
        return bless($dbh, $pkg);
    } else {
	cluck "connect($dsn,$user,$password):$DBI::errstr";
        # Create a BioPerl object in order to throw an exception
        my $self = bless {}, $pkg;
        $self->throw("Can't connect to SQL database with:\n"
            . "       dsn = '$dsn'\n"
            . "      user = '$user'\n"
            . "  password = '$password'\n"
            );
    }
}

sub Ofixsql {
    my ($sql) = @_;

    $sql =~ s/;\s*$//s;

    my $newsql='';
    #print STDERR "{$sql}\n" if $ENV{'sql_debug'}>10;
              
    # Fix all the unquoted parts of the line
    while($sql) {
	my($fixme,$quoted);
        if($sql=~ /([^'\\]*)('[^'\\]*(\\.[^'\\]*)*')(.*)/s ) {
        #         1        2        3             4
	    ($fixme,$quoted,$sql)=($1,$2,$4);
	} else {
	    ($fixme,$quoted,$sql)=($sql,'','');
	}
	# Do something with  LENGTH( [xxxx.]SEQUENCE )
	$fixme =~ s/\b(SEQUENCE|SYNONYM|START)\b/ORCL_$1/ig;
	$fixme =~ s/\bSTRAIGHT_JOIN\b//ig;
	$fixme =~ s/--/- -/g;
	$fixme =~ s/\bIF\s*\(([^,]*)=([^,]*),/DECODE($1,$2,/ig;
	#$fixme =~ s/"(.*)"/'$1'/g;  # Would screw up "\"" (which probably never occurs)
	$fixme =~ s/"(([^"\\]|\\.)*)"/'$1'/g;
	   #we could also try to be smart and handle ' within " somewhere above
	$fixme =~ s/\bUNIX_TIMESTAMP\(([^()]+)\)/(($1-TO_DATE('01-JAN-1970','DD-MON-YYYY'))*86400)/ig;	#then
	$fixme =~ s/\bUNIX_TIMESTAMP\(\)/((SYSDATE-TO_DATE('01-JAN-1970','DD-MON-YYYY'))*86400)/ig;	#now
	$fixme =~ s/\bLIMIT\s+\d+(\s*,\d+)?\b//ig;
	$fixme =~ s/\bRHMaps\b/MapMarker/ig;
	$fixme =~ s/!(?!=)/ NOT /g;
	$newsql .= $fixme.$quoted;
    }
#    while($sql=~ /([^'\\]*)('[^'\\]*(\\.[^'\\]*)*')(.*)/s ) {
#        #         1        2        3             4
#	my($fixme,$quoted);
#	($fixme,$quoted,$sql)=($1,$2,$4);
#	#print STDERR "{$fixme}{$quoted}{$sql}\n";
#	$fixme =~ s/\b(SEQUENCE|SYNONYM|START)\b/ORCL_$1/ig;
#	$fixme =~ s/\bSTRAIGHT_JOIN\b//ig;
#	$fixme =~ s/--/- -/g;
#	$fixme =~ s/\bIF\s*\(([^,]*)=([^,]*),/DECODE($1,$2,/ig;
#	$newsql .= $fixme.$quoted;
#    }
#    $newsql.=$sql;

    return $newsql;
}

sub prepare {
    my( $dbh,$sql, @args ) = @_;

    $sql=Ofixsql($sql);

    print STDERR "!--!-prepare($sql)\n" if $sql =~ /"/;
    print STDERR "prepare($sql)\n" if $ENV{'sql_debug'}>3;
    
    my $sth = $dbh->SUPER::prepare($sql,@args);
    if ($sth) {
	#print STDERR "SQL.pm prepared $sql,",join(",",@args),"\n";
        bless($sth, 'Bio::EnsEMBL::DBSQL::SQL::StatementHandle');
        return $sth;
    } else {
        $dbh->throw("prepare($sql) failed: '$DBI::errstr'");
    }
}

sub selectall_arrayref {
    my ($dbh,$sql,@args) = @_;

    $sql=Ofixsql($sql) unless ref $sql;   #could be a statement handle

    print STDERR "!--!-selectall_arrayref($sql)\n" if $sql =~ /"/;
    
    my $ary_ref = $dbh->SUPER::selectall_arrayref($sql,@args);

    if (defined $ary_ref) {
	print STDERR "SQL.pm selectall_arrayref $sql,",join(",",@args),"\n"
							if $ENV{'sql_debug'}>3;
        return $ary_ref;
    } else {
        $dbh->throw("selectall_arrayref failed: '$DBI::errstr'");
    }
}

1;

__END__

=head1 NAME - Bio::EnsEMBL::DBSQL::SQL

=head1 DESCRIPTION

Ensembl's SQL compatability layer.

This module inherits from B<DBI::db>, overriding
the B<prepare> method to bless the created
statement handles into the
B<Bio::EnsEMBL::DBSQL::SQL::StatementHandle>
class.

Database handles created in
B<Bio::Ensembl::DBSQL::Obj> are blessed into one
of the database driver specific classes (eg:
B<Bio::EnsEMBL::DBSQL::SQL::mysql>) which inherit
from this class.

=head1 MEHTODS

=over 4

=item new

    my $dbh = Bio::EnsEMBL::DBSQL::SQL::<driver>->new($dsn, $user, $password);

Called by B<Bio::EnsEMBL::DBSQL::Obj::new>, it
creates a B<DBI::db> database handle, blesses it
into the SQL compatability driver package, and
returns it.

=item prepare

=head1 AUTHOR

James Gilbert B<email> jgrg@sanger.ac.uk

