package Transcript;

use Bio::Root::Object;
use vars qw(@ISA);
use strict;
use Bio::EnsemblViewer::DrawableElement;
use Bio::EnsemblViewer::LinearElement;
use Bio::EnsemblViewer::BasicElement;

@ISA = qw(Bio::Root::Object DrawableElement);




sub _initialize 
{
    my($self,@args) = @_;      
    
    my($transcript,$image_par)= $self->_rearrange([qw(TRANSCRIPT IMAGE_PAR)],@args);   
    my $make = $self->SUPER::_initialize;   

    $self->_get_image_par($image_par);
    $self->_get_transcript($transcript);
  
    return $make;     
}





sub draw_transcript
{
    my ($self)=@_;
     
    my $transcript=$self->_get_transcript;  
    my @exons=$transcript->each_Exon;
    my @sorted_exons=sort {$a->start <=>$b->start} @exons; 
    my $tr_len=abs($sorted_exons[$#exons]->end-$sorted_exons[0]->start); # since ->first_exon and ->last_exon don't work


  if ($sorted_exons[0]->strand ==-1){

      my $middle_point=0.5*$tr_len+$sorted_exons[0]->start;
      foreach my $exon (@sorted_exons){
	  my $new_start=$exon->end+2*($middle_point-$exon->end);
	  my $new_end=$exon->start+2*($middle_point-$exon->start);

	  $exon->start($new_start);
	  $exon->end($new_end);
      }
  }

    my @end_exons=sort {$a->start <=>$b->start} @sorted_exons; 




    my $first_counter;
    my $vc_test;

    foreach my $exon (@end_exons){
	$first_counter++;
	
	if ($first_counter ==1){$vc_test=$exon->strand;}	
	if ($vc_test != $exon->strand){$self->throw("VirtualContig needs debugging, Transcript with exons on opposite strands");}
    }





    my $linear=LinearElement->new($self->_get_image_par); 

    my $im_len=$self->_get_image_par->{x_img_len}-$self->_get_image_par->{left_margin}-$self->_get_image_par->{right_margin};
    my $factor=$im_len/$tr_len;


    my ($counter, $exon_start, $exon_end,$intron_end,$keep_exon_end,$intron_start);

    foreach my $exon (@end_exons){
	
	$counter++;

	if ($counter !=1){
	    my $intron_len=abs ($exon->start-$keep_exon_end);
	    $intron_end=$intron_start+$intron_len*$factor;
	    
	    my $y_start= 0.5*$self->_get_image_par->{y_img_len}-0.5*$self->intron_height;
	    my $y_end= 0.5*$self->_get_image_par->{y_img_len}+0.5*$self->intron_height;
  
	    my %args= (name=> $exon->id,type=>'drawable', subtype=>'filledrect',color=>$self->intron_color,
		       x_start=>$intron_start,x_end=>$intron_end,y_start=>$y_start,y_end=>$y_end);
	    
	    $linear->_add_Element(BasicElement->new(%args));

	}
		
		
	my $exon_len=abs ($exon->end-$exon->start);

	if ($counter ==1){$exon_start=$self->_get_image_par->{left_margin};}
	else{$exon_start=$intron_end;}

	$exon_end=$exon_start+$exon_len*$factor;
	 
	my $y_start= 0.5*$self->_get_image_par->{y_img_len}-0.5*$self->exon_height;
	my $y_end= 0.5*$self->_get_image_par->{y_img_len}+0.5*$self->exon_height;

  
	my %args= (name=> $exon->id,type=>'drawable', subtype=>'filledrect',color=>$self->exon_color,
		   x_start=>$exon_start,x_end=>$exon_end,y_start=>$y_start,y_end=>$y_end);
	    
	$linear->_add_Element(BasicElement->new(%args));


	$intron_start=$exon_end;
	$keep_exon_end=$exon->end;

    }

    $self->_add_Element($linear);

}





sub exon_color
{
    my ($self,$color)=@_;
    
    if ($color){$self->{'exon_color'}=$color;}
    if (! defined $self->{'exon_color'}){$self->{'exon_color'}='black';}
    return $self->{'exon_color'};
   
}


sub intron_color
{
    my ($self,$color)=@_;
    
    if ($color){$self->{'intron_color'}=$color;}
    if (! defined $self->{'intron_color'}){$self->{'intron_color'}='black';}
    return $self->{'intron_color'};
   
}




sub exon_height
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'exon_height'}=$value;}

    if (! defined $self->{'exon_height'}){$self->{'exon_height'}=30;}
    return $self->{'exon_height'};
   
}


sub intron_height
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'intron_height'}=$value;}

    if (! defined $self->{'intron_height'}){$self->{'intron_height'}=2;}
    return $self->{'intron_height'};
   
}




sub _get_transcript
{
    my ($self,$transcript)=@_;
    
    if ($transcript){$self->{'transcript'}=$transcript;}
    return $self->{'transcript'};
   
}


sub _get_image_par
{
    my ($self,$image_par)=@_;
    
    if ($image_par){$self->{'image_par'}=$image_par;}
    return $self->{'image_par'};
   
}









1;





