package IntegratedMap;

use strict;
use Bio::EnsemblViewer::Chromosome;
use Bio::EnsemblViewer::Map;
use Bio::EnsemblViewer::Connection;
use Bio::EnsemblViewer::LinearElement;
use Bio::EnsemblViewer::BasicElement;
use Bio::EnsEMBL::DBSQL::KaryotypeBandAdaptor;
use Bio::Root::Object;
use vars qw(@ISA);



@ISA = qw(Bio::Root::Object DrawableElement);



sub _initialize 
{
    my($self,@args) = @_;      

    my ($db,$ensdb,$map_par,$image_par,$x_start,$x_end,$y_start,$y_end)= 
	$self->_rearrange([qw(DB IMAGE_PAR CHR)],@args);

    $db->isa('Bio::EnsEMBL::Map::DBSQL::Obj') || $self->throw("This is not a Bio::EnsEMBL::Map::DBSQL::Obj"); 
     my $make = $self->SUPER::_initialize;   
 

    $self->_get_image_par($image_par);
    $self->_x_start($x_start);
    $self->_x_end($x_end);
    $self->_y_start($y_start);
    $self->_y_end($y_end);

    $self->_get_map_par($map_par);
    if ( defined $map_par->{marker}){$self->set_map2marker($map_par->{marker})};   
    if ( defined $map_par->{marker_color}){$self->set_marker_color($map_par->{marker_color})};

    $self->_get_db($db);  
    $self->_get_ensdb($ensdb);  
   # $self->_get_all_markers($self->_get_map_par->{map});   

    return $make;     
}



sub all_maps
{

    my ($self)=@_; 

   
   
    my $chr=$self->_get_map_par->{chromosome};

    my $x_len=$self->_x_end-$self->_x_start;
    my $y_end=$self->_y_end;
    my $y_start=$self->_y_start;    
    my $x_start=$self->_x_start;
   
    my $y_print_start=$y_start;   

    my $linear=LinearElement->new();
    
    my $left_margin=10;
    my $chr_len=60;
    my $connect_len=30;
    my $RH_len=45;
    my $FPC_len=40;
    my $FISH_len = $x_len-$left_margin-$chr_len-$connect_len-$RH_len;#-$FPC_len;
   
   $y_start=$y_start+30;
    
    
    ###########
    # Draw FPC
    ###########
    my $x_start=$x_start+$left_margin;

#    my $x_end=$x_start+$FPC_len;
#
#    my %args=(name=>'FPC',type=>'printable',subtype=>'small',
#	      x_start=>$x_start-5,y_start=>$y_print_start,color=>'black');
#   $linear->_add_Element(BasicElement->new(%args));
#
#    $self->add_map('FPC',$x_start,$x_end,$y_start,$y_end,$self->set_RHmarkers_url);

    ##################
    # Draw Chromosome
    ##################
#    $x_start=$x_end;
    my $x_end=$x_start+$chr_len;
    my %args=(name=>"Chromosome ".$chr,type=>'printable',subtype=>'small',
	      x_start=>$x_start,y_start=>$y_print_start,color=>'black');
    $linear->_add_Element(BasicElement->new(%args));

    $self->_add_Element($linear);	

    $self->add_chromosome($chr,$x_start,$x_end,$y_start,$y_end);

    
    ############
    # Draw FISH
    ############
    $x_start=$x_end;
    $x_end=$x_start+$FISH_len;	
    
#    $self->add_map('FISH',$x_start,$x_end,$y_start,$y_end,$self->set_FISHmarkers_url,$self->_get_map_par->{map});
   
    ##################
    # Draw connection
    ##################
    $x_start=$x_end;  
    $x_end=$x_start+$connect_len;
#    my $legend_start;
#    if ($self->_get_map_par->{map} eq 'SG3-GB4'){$legend_start=$x_start-25;}
#    else {$legend_start=$x_start-10;}
#
#   %args=(name=>"RH: ".$self->_get_map_par->{map},type=>'printable',subtype=>'small', x_start=>$legend_start,y_start=>$y_print_start,color=>'black');
#   $linear->_add_Element(BasicElement->new(%args));
#
#    $self->_add_Element($linear);	
#
#    self->connect($x_start,$x_end,$y_start,$y_end,$self->_get_map_par->{map});


    ##########
    # Draw RH
    ##########
    $x_start=$x_end;
    $x_end=$x_end+$RH_len;
#    $self->add_map('RH',$x_start,$x_end,$y_start,$y_end,$self->set_RHmarkers_url);

}



sub add_chromosome
{
    my ($self,$chr,$x_start,$x_end,$y_start,$y_end)=@_;
   
    my $db=$self->_get_ensdb;
    my $kba = $db->get_KaryotypeBandAdaptor;
    my @chromosome = $kba->fetch_all_by_chromosome("chr$chr");
    my $arc_height=4;
    my $labels = 1;
    my $imagemap_bands = 1;
    my $chr=Chromosome->new(\@chromosome,$x_start,$x_end,$y_start,$y_end,$labels,$arc_height,$imagemap_bands);
    $self->_add_Element($chr);	

}



sub add_map
{

    my ($self,$map,$x_start,$x_end,$y_start,$y_end,$url,$map_id)=@_;
  
    my $markers;
    my $start;
    my $end;
    my $type;
    my @markers1;
    my @markers2;
    my $url;
    my @array1;
    my @array2;



 if ($map eq 'FISH')
    {
	$type='FISH';
	($start,$end)=$self->_get_range($type,$self->_get_FISH_markers);
	my @markers3=@{$self->_get_FISH_markers};
	$url=$self->set_FISHmarkers_url;


	@markers1=$self->_exclude_conflicting_markers(\@markers3,$map_id);

	my $counter;
	foreach (@markers1){$counter++;}

	$end=$counter;

       
    }


    if ($map eq 'RH')
    {
	$type='RH';
	($start,$end)=$self->_get_range($type,$self->_get_RH_markers);
	@markers1=@{$self->_get_RH_markers};
	$url=$self->set_RHmarkers_url;

    }

	
	my $i;
	for ($i=$start;$i<$end;$i++){
	    
	    push @markers2,@markers1[$i];
	    
	}

	
	$markers=\@markers2;


    if ($map eq 'FPC')
    {
	$markers=$self->_get_FPC_contigs;
	$url=$self->set_FPCmap_url;

    }

    my $map=Map->new($map,$markers,$x_start,$x_end,$y_start,$y_end,
		     $self->set_map2marker,$self->set_marker_color,
		     $self->set_FPCcontig,$self->set_FPCcontig_color,
		     $self->set_all_contigs_color,$url,$map_id,$self->_setFPCmap);
    
    if (defined $map->y_coord_ext){$self->y_coord_ext($map->y_coord_ext);}
  
    $self->_add_Element($map);	

}




sub connect

{
    my ($self,$x_start,$x_end,$y_start,$y_end,$map)=@_;
    my $type='connect';
    $self->_get_range($type,$self->_get_RH_markers);
    my $connection=Connection->new($self->_get_FISH_markers,$self->_get_RH_markers,
			    $self->_get_map_par,$x_start,$x_end,$y_start,$y_end,$self->set_RHmap_url,$map);

 $self->_add_Element($connection);	

}




sub set_map2marker
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'marker'}=$value;}
    return $self->{'marker'};
   
}


sub set_marker_color
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'marker_color'}=$value;}
    return $self->{'marker_color'};
   
}




sub set_FPCcontig
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'FPCcontig'}=$value;}
    return $self->{'FPCcontig'};
   
}


sub set_FPCcontig_color
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'FPCcontig_color'}=$value;}
    return $self->{'FPCcontig_color'};
   
}

sub set_all_contigs_color
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'allcontigs_color'}=$value;}
    if (! defined $self->{'allcontigs_color'}){$self->{'allcontigs_color'}='blue';}
    return $self->{'allcontigs_color'};
   
}









sub set_RHmarkers_url
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'RHmarkers_url'}=$value;}
    return $self->{'RHmarkers_url'};
   
}



sub set_FISHmarkers_url
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'FISHmarkers_url'}=$value;}
    return $self->{'FISHmarkers_url'};
   
}


sub set_RHmap_url
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'RHmap_url'}=$value;}
    return $self->{'RHmap_url'};
   
}

sub set_FPCmap_url
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'FPCmap_url'}=$value;}
    return $self->{'FPCmap_url'};
   
}


sub y_coord_ext
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'y_coord_ext'}=$value;}
    return $self->{'y_coord_ext'};
   
}



sub set_discrepancy_level
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'position_discrepancy'}=$value;}
    return $self->{'position_discrepancy'};
   
}




sub _get_all_markers
{

    my ($self,$map)=@_;

    my $chr=$self->_get_map_par->{chromosome};

    my $db=$self->_get_db;
   
    my $FISHmap = $db->get_Map('FISH');     
    my $RHmap =$db->get_Map($map);
    my $FPCmap=$db->get_Map('FPC'); 
   
    my $chr_FISHmap=$FISHmap->get_ChromosomeMap($chr);
    my $chr_RHmap=$RHmap->get_ChromosomeMap($chr);
    my $chr_FPCmap=$FPCmap->get_ChromosomeMap($chr);
 
    $self->_setFPCmap($FPCmap);

    $self->_get_RH_markers($chr_RHmap->get_MapMarkers);

    my @contigs=$chr_FPCmap->get_ordered_Contigs;

    $self->_get_FPC_contigs(\@contigs);



    my @FISHmarkers_new;

    foreach my $marker(@{$chr_FISHmap->get_MapMarkers}){

	my $status;
	foreach my $mp(@{$marker->marker->maps}){
	    if ($mp->id eq $map){$status=1;}
	}
	if ($status==1){
	    push @FISHmarkers_new,$marker;
	}  

    }
	

    my @FISH=@FISHmarkers_new;

 
	$self->_get_FISH_markers(\@FISH);

}



sub _get_RH_markers
{
    my ($self,$markers)=@_;
    
    if ($markers){$self->{'RHmarkers'}=$markers;}
    return $self->{'RHmarkers'};
   
}


sub _get_FISH_markers
{
    my ($self,$markers)=@_;
    
    if ($markers){$self->{'FISHmarkers'}=$markers;}
    return $self->{'FISHmarkers'};
   
}



sub _get_FPC_contigs
{
    my ($self,$contigs)=@_;
    
    if ($contigs){$self->{'FPCcontigs'}=$contigs;}

    return $self->{'FPCcontigs'};
   
}


sub _setFPCmap
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'FPCmap'}=$value;}

    return $self->{'FPCmap'};
   
}







sub _get_db
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'db'}=$value;}
    return $self->{'db'};
   
}



sub _get_ensdb
{
    my ($self,$value)=@_;
    
    if ($value){$self->{'ensdb'}=$value;}
    return $self->{'ensdb'};
   
}


sub _get_range
{


    my ($self,$type,$markers)=@_;

    my $marker_set=$self->_get_map_par->{marker_set};
    my $range;
   
    my $marker_counter;
    foreach (@{$markers}){$marker_counter++;}


  
    if (! defined $self->set_map2marker){$range=$self->_get_map_par->{$type.'_range'};}  
    elsif (defined $self->set_map2marker && ($type eq 'RH' || $type eq 'connect')) {
     

	my $counter;
	foreach my $marker (@{$self->_get_RH_markers})
	{
	  $counter++;    
	  if ($marker->marker->id eq $self->set_map2marker){last;}

	}


   
	
	if ($counter == $marker_counter){$self->throw('no such marker on this chromosome');}
		
	$range=int (($counter-1)/$marker_set);

	my $map_par=$self->_get_map_par;
	$map_par->{RH_range}=$range;
	$self->_get_map_par($map_par);
	
}

    my $marker_counter;
    foreach (@{$markers}){$marker_counter++;}
       
    my $start=$range*$marker_set;
    my $end=$start+$marker_set;
    if ($start>$marker_counter){$self->throw('beyond the', $type, 'range');}
    if ($end>=$marker_counter){$end=$marker_counter-1;}

    return my @arr=($start,$end);

}




sub _exclude_conflicting_markers
{


    my ($self,$markers,$map)=@_;

    my $FISH_hash;
    my $RH_sorted_hash;
    my $counter;
    my $ind_diff;
    my @marker_ids;
    my @final_markers;

    if (! defined $self->set_discrepancy_level){$ind_diff=500;}
    if (defined $self->set_discrepancy_level){$ind_diff=$self->set_discrepancy_level;}
    if ($self->set_discrepancy_level==0){$ind_diff=0;}

	
    foreach my $marker (@{$markers})
    {

	$counter++;
	$FISH_hash->{$marker->marker->id}=$counter;


    }



    my @RH_sorted_markers= (sort {$a->marker->get_MapMarkers->{$map}->position->coord<=>
			     $b->marker->get_MapMarkers->{$map}->position->coord}@{$markers});

   # my @FISH_sorted_markers= (sort {($a->position_guess)[0]<=>
#			     ($b->position_guess)[0]}@{$markers});

 #my @RH_sorted_markers= (sort {$a->position->coord<=>
#			     $b->position->coord}@new_markers);


    my $counter;

    foreach my $marker (@RH_sorted_markers)
    {

	$counter++;
	$RH_sorted_hash->{$marker->marker->id}=$counter;

    }


    foreach my $marker_id (keys %{$FISH_hash})
    {
	
	my $id=$marker_id;
	my $ind=$FISH_hash->{$marker_id};

	foreach my $marker_id (keys %{$RH_sorted_hash})
	{
	    
	    if($id eq $marker_id && abs ($ind-$RH_sorted_hash->{$marker_id})<=$ind_diff)
	    {

		push (@marker_ids,$marker_id);

	    } 

	}

    }


 
    foreach my $marker (@{$markers})
    {
	foreach my $marker_id(@marker_ids)
	{
	    if ($marker->marker->id eq $marker_id)
	    {
		push @final_markers,$marker;

	    }
	}
    }


    my @v_final_markers= (sort {$a->marker->get_MapMarkers->{$map}->position->coord<=>
			     $b->marker->get_MapMarkers->{$map}->position->coord}@final_markers);


 #my @v_final_markers= (sort {($a->position_guess)[0]<=>
#			     ($b->position_guess)[0]}@final_markers);

 #my @v_final_markers= (sort {$a->position->coord<=>
#			     $b->position->coord}@final_markers);


 
  
     
}





1;
























