package GIF;


use Bio::Root::Object;
use vars qw(@ISA);
use strict;
use GD;


@ISA = qw(Bio::Root::Object);


 
sub _initialize {
  
    my ($self,@args)=@_;      
    my $make = $self->SUPER::_initialize;
    my($element_list,$image_par,$fh)= $self->_rearrange([qw(ELEMENT_LIST IMAGE_PAR FILEHANDLE)],@args); 
    $self->{'elements'}=[];
    $self->_get_elements($element_list);      
    $self->{'element_array'} = []; 
    $self->_get_image_par($image_par);   
    $self->{'IMAP_elements'}=[];
    return $make; 
    
}




sub get_GIF

{
    my ($self,$fh)=@_;
    
    my $im=$self->_get_image;  
    my $colors=$self->_colors($im);         
   
    foreach my $element ($self->_get_elements)
    {
        my @args=($im,$colors,$element);
        
        ######################
        # draw image elements
        ######################
        if ($element->type eq 'drawable'){
            if ($element->subtype eq 'rect' ){$self->_draw_rect(@args);}
            if ($element->subtype eq 'filledrect' ){$self->_draw_filled_rect(@args);}
            if ($element->subtype eq 'arc_down' ){$self->_draw_arc_down(@args);}
            if ($element->subtype eq 'arc_up' ){$self->_draw_arc_up(@args);}
            if ($element->subtype eq 'triangle_up' ){$self->_draw_triangle_up(@args);}
            if ($element->subtype eq 'triangle_down' ){$self->_draw_triangle_down(@args);}
            if ($element->subtype eq 'line' ){$self->_draw_line(@args);}
            if ($element->subtype eq 'semi_up' ){$self->_draw_semi_up(@args);}
            if ($element->subtype eq 'semi_down' ){$self->_draw_semi_down(@args);}
            if ($element->subtype eq 'poly' ){$self->_draw_poly(@args);}
            if ($element->subtype eq 'filledpoly' ){$self->_draw_filled_poly(@args);}
        } # end if drawable
        
        ##################
        # draw label text
        ##################
        if ($element->type eq 'printable'){$self->_print_element(@args);}   
        
        
        ##########################
        # load the image map list
        ##########################
        if ($element->type eq 'IMAP'){$self->_print_image_map_element (@args,$fh)};
        
        #push $self->{'IMAP_elements'},$element;}
            
    }
    
    ##########################
    # dump the image map list
    ##########################
    #$self->_print_image_map ($fh); 

        
    if ($im->can("gif")){
    my $gif=$im->gif;    
    }
    else {
    my $gif=$im->png;    
    }

}



sub _get_elements
{
    my ($self,$elements)=@_;
    if ($elements){$self->{'elements'}=$elements;}
    return @{$self->{'elements'}};
   
}



sub _get_IMAP_elements
{
    my ($self,$elements)=@_;
    if ($elements){$self->{'IMAP_elements'}=$elements;}
    return @{$self->{'IMAP_elements'}};
   
}


sub _get_image
{
    my ($self)=@_; 

    my $param=$self->_get_image_par;
    my $length=$param->{x_img_len};
    my $width=$param->{y_img_len};
    my $im=new GD::Image($length,$width);
    my $yellow = $im->colorAllocate(255,255,231);
    my $black  = $im->colorAllocate(0,0,0); 
    $im->rectangle(0,0,$length-1,$width-1,$black);
    return $im;
}



sub _get_image_par
{
    my ($self,$image_par)=@_;
    
    if ($image_par){$self->{'image_par'}=$image_par;}
    return $self->{'image_par'};
   
}


sub _draw_rect
{
    my ($self,$im,$gd_col_ref,$element)=@_;                                
    $im->rectangle($element->x_start,$element->y_start,$element->x_end,$element->y_end,$gd_col_ref->{$element->color}); 
}

sub _draw_filled_rect
{
    my ($self,$im,$gd_col_ref,$element)=@_;                                
    $im->filledRectangle($element->x_start,$element->y_start,$element->x_end,$element->y_end,$gd_col_ref->{$element->color});  
}


sub _draw_line
{
    my ($self,$im,$gd_col_ref,$element)=@_;                               
    $im->line($element->x_start,$element->y_start,$element->x_end,$element->y_end,$gd_col_ref->{$element->{color}});    
    
}




sub _draw_arc_up
{
    my ($self,$im,$gd_col_ref,$element)=@_;                               
    
    my $x_start    = $element->x_start;
    my $x_end      = $element->x_end;
    my $arc_height = $element->arc_height;
    my $y_start    = $element->y_start;
    my $y_end      = $element->y_end;
    #my $arc_height = $element->arc_height;
    my $color      = $gd_col_ref->{$element->color};
    my $fillcolor  = $gd_col_ref->{$element->fillcolor};

    
    ###################
    # Draw initial arc
    ###################
    $im->arc(
                ($x_end+$x_start)*0.5,
                $y_start+$arc_height,
                $x_end-$x_start,
                2*$arc_height,
                180,
                0,
                $color
             );
             
     
    ####################################
    # fill the arc with the fill colour
    ####################################     
     $im->fill(
                ($x_end+$x_start)*0.5,
                $y_start+(0.5*$arc_height),
                $fillcolor
                );

}



sub _draw_arc_down
{
    my ($self,$im,$gd_col_ref,$element)=@_;                               
    
    my $x_start=$element->x_start;
    my $x_end=$element->x_end;
    my $arc_height=$element->arc_height;
    my $y_start=$element->y_start;
    my $y_end=$element->y_end;
    my $arc_height=$element->arc_height;
    my $color=$gd_col_ref->{$element->color};
    my $fillcolor=$gd_col_ref->{$element->fillcolor};

    ###################
    # Draw initial arc
    ###################
    $im->arc(
                ($x_end+$x_start)*0.5,
                $y_end-$arc_height,
                $x_end-$x_start,
                2*$arc_height,
                0,
                180,
                $color
            );

                
    ####################################
    # fill the arc with the fill colour
    ####################################  
    $im->fill(
                ($x_end+$x_start)*0.5,
                $y_end-($arc_height*0.5),
                $fillcolor
                );
                
}





sub _draw_triangle_down
{
 
 my ($self,$im,$gd_col_ref,$element)=@_; 

 my $poly = new GD::Polygon;
 $poly->addPt($element->x_start,$element->y_start);
 $poly->addPt($element->x_end,$element->y_start);
 $poly->addPt(($element->x_end-$element->x_start)*0.5+$element->x_start,$element->y_end);
 $im->filledPolygon($poly,$gd_col_ref->{$element->color});

}

sub _draw_triangle_up
{
 
 my ($self,$im,$gd_col_ref,$element)=@_; 


 my $poly = new GD::Polygon;
 $poly->addPt($element->x_start,$element->y_end);
 $poly->addPt($element->x_end,$element->y_end);
 $poly->addPt(($element->x_end-$element->x_start)*0.5+$element->x_start,$element->y_start);
 $im->filledPolygon($poly,$gd_col_ref->{$element->color});

}


sub _draw_poly 
{

 my ($self,$im,$gd_col_ref,$element)=@_; 

 my $poly = new GD::Polygon;
 my $x_y=$element->x_y;

 foreach my $href(@$x_y){
    $poly->addPt($href->{'x'},$href->{'y'});
    }
 $im->polygon($poly,$gd_col_ref->{$element->color});

}



sub _draw_filled_poly 
{

 my ($self,$im,$gd_col_ref,$element)=@_; 

 my $poly = new GD::Polygon;
 my $x_y=$element->x_y;

 foreach my $href(@$x_y){
    $poly->addPt($href->{'x'},$href->{'y'});
    }
 $im->filledPolygon($poly,$gd_col_ref->{$element->fillcolor});
 $im->polygon($poly,$gd_col_ref->{$element->color});

}



sub _print_element
{

    my ($self,$im,$gd_col_ref,$element)=@_;
    
    if ($element->subtype eq 'tiny')
    {
    $im->string(gdTinyFont,$element->x_start,$element->y_start,$element->name,$gd_col_ref->{$element->color});
}

 if ($element->subtype eq 'medium')
 {
     $im->string(gdMediumBoldFont,$element->x_start,$element->y_start,$element->name,$gd_col_ref->{$element->color});
 }

 if ($element->subtype eq 'small')
 {
     $im->string(gdSmallFont,$element->x_start,$element->y_start,$element->name,$gd_col_ref->{$element->color});
 }

}


#sub _print_image_map
#{
#
#    my ($self,$fh)=@_;
#    
#   foreach my $element ($self->_get_IMAP_elements){
#       }
#   
#    print  $fh "<AREA Shape=\"Rect\" coords = \"",int $element->x_start," ",int $element->y_start,
#    " ",int $element->x_end," ",int $element->y_end," \"  HREF=\"",$element->url,"\"","alt=\"",$element->mouseover,"\">","\n";
#    
#}



sub _print_image_map_element
{
    my ($self,$im,$colors,$element,$fh)=@_;

    #########
    # daft hack to make sure links work if there's no javascript (rmp 04-10-00)
    #
    my $onmouseover = "";
    my $alt  = $element->mouseover;
    my $href = $element->url;

    if($href =~ /^javascript/) {
        $onmouseover = 'onmouseover="' . $href . '"';
    $href        = "javascript:void(0);";
    $alt         = "";
    }

    print  $fh '<AREA Shape="Rect" coords="',
        int $element->x_start, ' ', int $element->y_start, ' ',
        int $element->x_end,   ' ', int $element->y_end, '" ',
        'href="', $href, '" ', $onmouseover, 
        ' alt="', $alt, '">', "\n";
    
}



sub _colors
{

    my ($self,$im)=@_;    
    my $colors_ref={};

    $colors_ref->{yellow}     = $im->colorAllocate(255,255,231);
    $colors_ref->{white}      = $im->colorAllocate(255,255,255);
    $colors_ref->{grey}       = $im->colorAllocate(192,192,192);
    $colors_ref->{lightgrey}  = $im->colorAllocate(200,200,200);
    $colors_ref->{lightgrey1}  = $im->colorAllocate(210,210,210);
    $colors_ref->{lightgrey2}  = $im->colorAllocate(220,220,220);
    $colors_ref->{lightgrey3}  = $im->colorAllocate(230,230,230);
    $colors_ref->{lightgrey4}  = $im->colorAllocate(240,240,240);
    $colors_ref->{lightgrey5}  = $im->colorAllocate(250,250,250);
    $colors_ref->{darkgrey}   = $im->colorAllocate(90,90,90);  
    $colors_ref->{black}      = $im->colorAllocate(0,0,0);         
    $colors_ref->{red}        = $im->colorAllocate(238,0,0);
    $colors_ref->{brightred}  = $im->colorAllocate(255,0,0);
    $colors_ref->{green}      = $im->colorAllocate(0,255,0);
    $colors_ref->{blue}       = $im->colorAllocate(0,0,255);
    $colors_ref->{blue2}      = $im->colorAllocate(0,4,182);
    $colors_ref->{darkgreen}  = $im->colorAllocate(50,80,50);
    $colors_ref->{chocolate}  = $im->colorAllocate(210,105,30);
    $colors_ref->{brown}      = $im->colorAllocate(165,42,42);
    $colors_ref->{blueviolet} = $im->colorAllocate(138,43,226);
    $colors_ref->{darkorange} = $im->colorAllocate(255,127,0);
    $colors_ref->{mustard}    = $im->colorAllocate(205,207,33);
    $colors_ref->{violet3}    = $im->colorAllocate(226,226,255);
    $colors_ref->{pine}       = $im->colorAllocate(0,150,28);
    $colors_ref->{flora}      = $im->colorAllocate(202,209,13);
    $colors_ref->{chartreuse} = $im->colorAllocate(127,255,0);
    $colors_ref->{light_sea_green} = $im->colorAllocate(32,178,170);
    $colors_ref->{indian_red} = $im->colorAllocate(205,92,92);
    $colors_ref->{fire_brick} = $im->colorAllocate(178,34,34);
    $colors_ref->{deep_pink}  = $im->colorAllocate(255,20,147);
    $colors_ref->{violet}     = $im->colorAllocate(238,130,238);
    $colors_ref->{violet1}    = $im->colorAllocate(220,170,245);
    $colors_ref->{violet2}    = $im->colorAllocate(200,200,255);
    $colors_ref->{rust}       = $im->colorAllocate(160,0,0);
    $colors_ref->{sangerblue} = $im->colorAllocate(82,130,214);
    $colors_ref->{darkcyan}   = $im->colorAllocate(0,139,139);
    $colors_ref->{gold}       = $im->colorAllocate(255,215,0);
    $colors_ref->{ebigreen}   = $im->colorAllocate(22,139,22);

    return $colors_ref;
}






1;











