package DrawableElement;

use strict;
#use Bio::EnsEMBL::Map::DBSQL::Map;
#use Bio::EnsEMBL::Map::DBSQL::Obj;
use Bio::EnsemblViewer::LinearElement;
use Bio::EnsemblViewer::Chromosome;
use Bio::Root::RootI;
use vars qw(@ISA);
use Bio::EnsemblViewer::GIF;


@ISA = qw(Bio::Root::RootI);




sub get_GIF
{
    my ($self,$fh)=@_;

    my @element_list;
    my $var=$self;
    foreach my $el($var->_each_Element){
	
	if ($el->isa("LinearElement")){
	    push @element_list,$el->_each_Element;
	    #print STDERR "I am linear 1 ", $el->name,"\n";
	}    
	else {
	    #print STDERR "not a linear 1 element\n";
	    $var=$el;
	    
	    foreach my $el($var->_each_Element){
    
		if ($el->isa("LinearElement")){
		    push @element_list,$el->_each_Element;
		    #print STDERR "I am linear 2 ", $el->name,"\n";
		}    
		else {
		    #print STDERR "not a linear 2 element\n";
		    $var=$el;
		    
		    foreach my $el($var->_each_Element){
			
			if ($el->isa("LinearElement")){
			    push @element_list,$el->_each_Element;
			    #print STDERR "I am linear 3\n";
			}    
			else {
			    #print STDERR "not a linear 3 element\n";
			    $var=$el;
			}
		    }
		}
	    }
	}
	
    }
    
    my $var=GIF->new(\@element_list,$self->_get_image_par,$fh);
    my $gif=$var->get_GIF($fh);
    
}


sub get_PostScript
{

    my ($self)=@_;

    $self->throw('method not implemented yet');  
}


sub get_PNG
{

    my ($self)=@_;

    $self->throw('method not implemented yet');  
}






sub _x_start
{
    my ($self,$value)=@_;
    
    if (defined $value){$self->{'x_start'}=$value;}
    return $self->{'x_start'};
   
}


sub _x_end
{
    my ($self,$value)=@_;
    
    if (defined $value){$self->{'x_end'}=$value;}
    return $self->{'x_end'};
   
}

sub _y_start
{
    my ($self,$value)=@_;
    
    if (defined $value){$self->{'y_start'}=$value;}
    return $self->{'y_start'};
   
}


sub _y_end
{
    my ($self,$value)=@_;
    
    if (defined $value){$self->{'y_end'}=$value;}
    return $self->{'y_end'};
   
}





sub _add_Element 
{
    my($self,$element) = @_;
    
    if( !$element) {$self->throw ("Cannot add a non existant element\n");}
    push(@{$self->{'element_array'}},$element);
}



sub _each_Element 
{
    my ($self) = shift;
    if( !defined $self->{'element_array'} ) {
	return ();
    }
    return ( @{ $self->{'element_array'}});
}



sub _get_image_par
{
    my ($self,$image_par)=@_;
    
    if ($image_par){$self->{'image_par'}=$image_par;}
    return $self->{'image_par'};
   
}



sub _get_map_par
{
    my ($self,$map_par)=@_;
    
    if ($map_par){$self->{'map_par'}=$map_par;}
    return $self->{'map_par'};
   
}



1;




















