


#
# Ensembl module for Bio::EnsEMBL::ExternalData::TCORE::TcoreAdaptor
#
# Cared for by Ewan Birney <birney@ebi.ac.uk>
#
# Copyright GRL and EBI
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::ExternalData::TCORE::TcoreAdaptor - DESCRIPTION of Object

=head1 SYNOPSIS

Give standard usage here

=head1 DESCRIPTION

Describe the object here

=head1 CONTACT

Ensembl - ensembl-dev@ebi.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::ExternalData::TCORESQL::TcoreAdaptor;
use vars qw(@ISA);
use strict;

# Object preamble - inheriets from Bio::Root::RootI
use Bio::EnsEMBL::ExternalData::Tcore;
use Bio::EnsEMBL::DB::ExternalFeatureFactoryI;
use Bio::Root::RootI;


@ISA = qw(Bio::Root::RootI Bio::EnsEMBL::DB::ExternalFeatureFactoryI);

sub new {
    my($class,$db) = @_;
    my $self;
    $self = {};
    bless $self, $class;
    if( ! defined $db ) {
      $self->throw( "Cant make adaptor without dbadaptor" );
    }
    $self->db( $db );

    return $self; # success - we hope!
}


=head2 fetch_Tcore_by_dbID

 Title   : fetch_Tcore_by_dbID
 Usage   :
 Function:
 Example :
 Returns : 
 Args    :


=cut

sub fetch_Tcore_by_dbID{
   my ($self,$id) = @_;

   $self->throw("I need an id") unless defined $id;
   my $sth = $self->prepare("select rc_start,start_bp,end_bp from Tcore where groupId= $id");
   $sth->execute;
   my ($contig_id,$start,$end,$strand) = $sth->fetchrow_array();

   return Bio::EnsEMBL::ExternalData::Tcore->create_from_array($id,$contig_id,$start,$end,$self);
   
}






=head2 get_Ensembl_SeqFeatures_contig

 Title   : get_Ensembl_SeqFeatures_contig
 Usage   : get_Ensembl_SeqFeatures_contig($raw_contig,$start,$end);
 Function:

    The semantics of this method are as follows:

    $raw_contig - the ensembl contig id (external id).

    The $start/$end can be ignored, but methods can take advantage of it.
    This is so that ensembl can ask for features only on a region of DNA,
    and if desired, the external database can respond with features only
    in this region, rather than the entire sequence.

 Example :
 Returns : list of Bio::SeqFeature::Tcore objects
 Args    : $raw_contig,
           $start of range, optional
           $end of range, optional


=cut

sub get_Ensembl_SeqFeatures_contig {
    my $self = shift;
    my $rcid = shift;


  
    my @tcore;

    if ( ! defined $rcid) {
	$self->throw("Raw contig ID is required to retrieve a trace!");
    }
#     if (defined $start) {
# 	$start = 1 if $start eq "";
# 		if ( $start !~ /^\d+$/ || $start < 0) {
# 	    	$self->throw("$start is not a valid start");
# 		}
#     }
#     if (defined $stop) {
# 	$start = 1 if not defined $start;
# 		if ( $stop !~ /^\d+$/ || $stop < 0 ) {
# 	    	$self->throw("$stop is not a valid stop");
# 		}
#     }

#     if (defined $start and defined $stop) {
# 		if ($stop < $start) {
# 	    	$self->throw("Cannot stop before you start! ($stop < $start)");
# 		}
#     }

    my $query="select groupId,rc_start,start_bp,end_bp from Tcore where rc_start='$rcid'";

    my $sth = $self->prepare($query);
    my $res = $sth->execute();

    my ($tcore_id,$contig_id,$start,$end,$strand);

    $sth->bind_columns(undef,\$tcore_id,\$contig_id,\$start,\$end);


    while( $sth->fetch() ) {

	my $tcore=Bio::EnsEMBL::ExternalData::Tcore->create_from_array
	    ($tcore_id,$contig_id,$start,$end,$self);
	my @dlinks = $tcore->each_DBLink;
        if ( scalar @dlinks == 0 ) {
            my $link = new Bio::Annotation::DBLink;
            $link->database('Ensembl Trace Server');
            $link->primary_id("hh");
            #add dbXref to Trace
            $tcore->add_DBLink($link);
        }
	
#	my @trace_ids;

#	my $query="select rn.readName from Readnames rn,Hit ht 
#               where rn.readId=ht.readId and ht.groupId='tcore_id'";
	
#	my $sth = $self->_db_handle->prepare($query);
#	$sth->execute();
	
#	my $id;
#	$sth->bind_columns(undef,\$id);
	
#	while( $sth->fetch() ) {
#	    push @trace_ids,$id;
#	}
#	$tcore->id($trace_ids[0]);

	push @tcore,$tcore;
    }

    return @tcore;

}





=head2 get_Ensembl_SeqFeatures_clone

 Title   : get_Ensembl_SeqFeatures_clone (not used)
 Usage   :
 Function:
 Example :
 Returns :
 Args    :

=cut

sub get_Ensembl_SeqFeatures_clone{
   my ($self) = @_;
   return;
}


=head2 list_hits_by_tcoreId

 Title   : list_hits_by_tcoreId
 Usage   : $adaptor->list_hits_by_tcoreId( $a_tcore_Id )
 Function:
 Example :
 Returns : ref to array of refs, no objects
            each part list is 
            readname, raw_contig_id startbp, length, strand
 Args    :

=cut

sub list_hits_by_tcoreId {
  my $self = shift;
  my $tcoreId = shift;

  my $sth = $self->prepare( "select rn.readName, rc_id, rc_start, abs(length_strand), if( length_strand>0, 1, -1 ) from Readnames rn, Hit h where h.readId = rn.readId and h.groupId = $tcoreId" );
  $sth->execute;
  my $res = $sth->fetchall_arrayref;
  return @$res;
}


=head2 prepare

 Title   : prepare
 Usage   : $sth = $dbobj->prepare("select seq_start,seq_end from feature where analysis = \" \" ");
 Function: prepares a SQL statement on the DBI handle

           If the debug level is greater than 10, provides information into the
           DummyStatement object

 Example :
 Returns : A DBI statement handle object
 Args    : a SQL string

=cut

sub prepare {
    my ($self,$string) = @_;

   if( ! $string ) {
       $self->throw("Attempting to prepare an empty SQL query!");
   }

   return $self->db->prepare($string);
}

=head2 db

 Title   : db
 Usage   : $obj->db($newval)
 Function: the source of all adaptors
 Example :
 Returns : value of db
 Args    : newvalue (optional)


=cut

sub db {
   my ($self,$value) = @_;
   if( defined $value) {
      $self->{'_db'} = $value;
    }
    return $self->{'_db'};

}














