


#
# Ensembl module for Bio::EnsEMBL::ExternalData::TCORE::TcoreAdaptor
#
# Cared for by Ewan Birney <birney@ebi.ac.uk>
#
# Copyright GRL and EBI
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::ExternalData::TCORE::TcoreAdaptor - DESCRIPTION of Object

=head1 SYNOPSIS

Give standard usage here

=head1 DESCRIPTION

Describe the object here

=head1 CONTACT

Ensembl - ensembl-dev@ebi.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::ExternalData::TCORESQL::DBAdaptor;
use vars qw(@ISA);
use strict;

# Object preamble - inheriets from Bio::Root::RootI
use Bio::EnsEMBL::ExternalData::Tcore;
use Bio::EnsEMBL::ExternalData::TCORESQL::TcoreAdaptor;
use Bio::EnsEMBL::DB::ExternalFeatureFactoryI;
use Bio::Root::RootI;
use DBI;


@ISA = qw(Bio::Root::RootI Bio::EnsEMBL::DB::ExternalFeatureFactoryI);

sub new {
    my($class,@args) = @_;
    my $self;
    $self = {};
    bless $self, $class;
    
    my ($db,$host,$port,$driver,$user,$password) =
	$self->_rearrange([qw(DBNAME
			      HOST
			      PORT
			      DRIVER
			      USER
			      PASS
			      )],@args);
    
    $db   || $self->throw("Database object must have a database name");
    $user || $self->throw("Database object must have a user");
    
    if( ! $driver ) {
	$driver = 'mysql';
    }
    if( ! $host ) {
	$host = 'localhost';
    }

    my $dsn;
    if($driver =~ /Oracle/i ) {
        $dsn="DBI:$driver:$db"; 
    } else {
	if (! $port ) {
	    $port = 3306;
	}
	$dsn = "DBI:$driver:database=$db;host=$host;port=$port";
    }
    my $dbh = DBI->connect("$dsn","$user",$password);
    
    $dbh || $self->throw("Could not connect to database $db user $user using [$dsn] as a locator");
    
    $self->_db_handle($dbh);
    
    return $self; # success - we hope!
}


=head2 get_TcoreAdaptor

 Title   : get_TcoreAdaptor
 Usage   :
 Function:
 Example :
 Returns : 
 Args    :


=cut


sub get_TcoreAdaptor {
  my $self = shift;
  if( ! defined $self->{_TcoreAdaptor} ) {
    $self->{_TcoreAdaptor} = Bio::EnsEMBL::ExternalData::TCORESQL::TcoreAdaptor->new( $self );
  }
  return $self->{_TcoreAdaptor};
}

sub prepare {
  my $self = shift;
  my $query = shift;

  return $self->_db_handle->prepare( $query );
}


sub _db_handle {
  my $self = shift;
  my $handle = shift;
  
  if( defined $handle ) {
    $self->{_db_handle} = $handle;
  }

  return $self->{_db_handle};
}
