# BioPerl module for Bio::EnsEMBL::Map::PositionI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 25.01.2000
# Last modified : 09.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::PostionI

=head1 SYNOPSIS


=head1 DESCRIPTION

    The general idea what a posititon in the Map can do.

=head1 CONTACT

    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::PositionI;
use vars qw(@ISA);
use strict;
use Bio::Root::RootI;

@ISA = qw( Bio::Root::RootI );

=head2 id

    Title   : id  
    Usage   : ...::PositionI->id;
    Function: returns a string that describes this positon
    Example : -
    Returns : -
    Args    : -

=cut

sub id {
    my $self = shift;
    $self->throw( "Function id not implemented in ".ref( $self )."!" );;
}

=head2 guess_Basepairs

    Title   : guess_Basepairs
    Usage   : $positionInt = ...::PositionI->guess_Basepairs;
    Function: returns a guess, how many basepairs from beginning this
    position is  
    Example : -
    Returns : a probably very big integer number ( -10^10)
    Args    : -

=cut

sub guess_Basepairs {
    my $self = shift;
    $self->throw( "Function guess_Basepairs not implemented in ".ref( $self )."!" );;
}


=head2 is_between

    Title   : is_between
    Usage   : $bool = ...::PositionI->is_between( $pos1, $pos2 );
    Function: Is this position between the given positions? There is no
    check, if they are on the same chromosome. But there is a check if the
    yare of the same type.
    Example : -
    Returns : 0,1 or exception if they are not compareable
    Args    : -

=cut

sub is_between {
    my $self = shift;
    $self->throw( "Function is_between not implemented in ".ref( $self )."!" );;
}

=head2 is_higher

    Title   : is_higher
    Usage   : $bool = ...::PositionI->is_higher( $pos );
    Function: Is this position further down than the given one?
    Example : -
    Returns : 0,1 or exception if they are not compareable
    Args    : -

=cut

sub is_higher {
    my $self = shift;
    $self->throw( "Function is_higher not implemented in ".ref( $self )."!" );
}

=head2 is_lower

    Title   : is_lower
    Usage   : $bool = ...::PositionI->is_lower( $pos );
    Function: Is this position further up than the given one?
    Example : -
    Returns : 0,1 or exception if they are not compareable
    Args    : -

=cut

sub is_lower {
    my $self = shift;
    $self->throw( "Function is_lower not implemented in ".ref( $self )."!" );
}
# compiled successfull

1;
