# BioPerl module for Bio::EnsEMBL::Map::MarkerI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 19.01.2000
# Last modified : 09.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::MarkerI

=head1 SYNOPSIS


=head1 DESCRIPTION

    Contains all the functionality of the Marker
    object, which the objects in the special driver direcories have to
    implement. (eg. DBSQL::Marker )

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::MarkerI;
use vars qw(@ISA);
use strict;
use Bio::Root::RootI;


@ISA = qw( Bio::Root::RootI );

# Object preamble - inheriets from Bio::Root::Object

# new() is inherited from Bio::Root::Object
# _initialize is where the heavy stuff will happen when new is called

=head2 id

    Title   : id  
    Usage   : ...::MarkerI->id;
    Function: returns an id string for a Marker
    Example : $marker->id;
    Returns : 
    Args    : -

=cut

sub id {
    my ($self) = @_;
    $self->throw( "Function id not implemented in ".ref($self)."!" );
}

=head2 synonyms

    Title   : synonyms  
    Usage   : ...::MarkerI->synonyms;
    Function: returns an array refernce to all known synonyms
    Example : $arrRef = $marker->synonyms;
    Returns : -
    Args    : -

=cut

sub synonyms {
    my ($self) = @_;
    $self->throw( "Function synonyms not implemented in ".ref($self)."!" );
}

=head2 maps

    Title   : maps  
    Usage   : $refArrMaps = ...::MarkerI->maps;
    Function: returns an array refernce to all Maps objects this marker is in.
    Example : $arrRef = $marker->maps;
    Returns : -
    Args    : -

=cut

sub maps {
    my ($self) = @_;
    $self->throw( "Function maps not implemented in ".ref($self)."!" );
}

=head2 chromosomeMaps

    Title   : chromosomeMaps  
    Usage   : $refArrChrMaps = ...::MarkerI->chromosomeMaps;
    Function: returns an array refernce to all ChromosomeMap objects this
    marker is in. 
    Example : $arrRef = $marker->chromosomeMaps;
    Returns : -
    Args    : -

=cut

sub chromosomeMaps {
    my ($self) = @_;
    $self->throw( "Function chromosomeMaps not implemented in ".ref($self)."!" );
}

=head2 get_MapMarkers

    Title   : get_MapMarkers  
    Usage   : $refArrMapMarkers = ...::MarkerI->get_MapMarkers;
    Function: returns an array refernce to the actual MapMarker objects,
    which represent this Marker in the Maps.
    Example : $arrRef = $marker->get_MapMarkers;
    Returns : -
    Args    : -

=cut

sub get_MapMarkers {
    my ($self) = @_;
    $self->throw( "Function get_MapMarkers not implemented in ".ref($self)."!" );
}

=head2 type

    Title   : type  
    Usage   : $typeString = ...::MarkerI->type;
    Function: A typestring could be "EST","STS", "framework" ...?
    Example : -
    Returns : -
    Args    : -

=cut

sub type {
    my ($self) = @_;
    $self->throw( "Function type not implemented in ".ref($self)."!" );
}

=head2 get_Marker_SeqFeatures

    Title   : get_Marker_SeqFeature
    Usage   : $seqFeatures = ...::MarkerI->get_Marker_SeqFeature;
    Function: Give ArrayReference to FeaturePair objects for the Marker.
    Example : -
    Returns : Reference to an array of FeaturePair objects. Empty array if it has none.
    Args    : -

=cut

sub get_Marker_SeqFeature {
    my ($self) = @_;
    $self->throw( "Function get_Marker_SeqFeature not implemented in ".ref($self)."!" );
}

# =head2 has_Marker_SeqFeatures

#     Title   : has_Marker_SeqFeatures
#     Usage   : $bool = ...::MarkerI->has_Marker_SeqFeatures;
#     Function: Has the Marker SeqFeature objects? 
#     Example : -
#     Returns : Return 0,1;
#     Args    : -

# =cut

# sub has_Marker_SeqFeature {
#     my ($self) = @_;
#     $self->throw( "Function has_Marker_SeqFeature not implemented in ".ref($self)."!" );
# }




# compiled successfull

1;
