# BioPerl module for Bio::EnsEMBL::Map::MarkerFeature
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 26.04.2000
# Last modified : 26.04.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

    Bio::EnsEMBL::Map::MarkerFeature

=head1 SYNOPSIS


=head1 DESCRIPTION

    Connects the Map database to the sequence database. Gives an 
    additional get_Marker call to the normal FeaturePair and has
  a link to the Map::DBSQL::Obj object.

=head1 CONTACT

    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

    The rest of the documentation details each of the object methods. 
    Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::MarkerFeature;
use vars qw(@ISA);
use strict;

@ISA = qw( Bio::EnsEMBL::FeaturePair );

# Object preamble - inheriets from Bio::Root::Object

# new() is inherited from Bio::Root::Object
# _initialize is where the heavy stuff will happen when new is called

sub new {
  my $class = shift;
  my $self = $class->SUPER::new( @_ );

  $self;
}

=head2 get_Marker

  Title   : get_Marker
  Usage   : $ma_fea_pair->get_Marker()
  Function: gets the marker associated with this Feature.
  Example : -
  Returns : a Marker object
  Args    : -

=cut

sub get_Marker {
  my $self = shift;
  my $hid = $self->hseqname;
  my $mapdb = $self->mapdb;
  my $sth = $mapdb->prepare
    ( "select marker from MarkerSynonym ".
      "where name='$hid' and ".
      "db='EMBL'" );
  my ( $marker, $markerId );
  $sth->execute;

  ($markerId) = $sth->fetchrow_array;
  $marker = Bio::EnsEMBL::Map::DBSQL::Marker->new
    ( $mapdb, $markerId );

  return $marker;
}

# get set the Map::DBSQL::Obj for this feature
sub mapdb {
  my $self = shift;
  my $mapdb = shift;
  $mapdb &&
    ( $self->{_MarkerFeature_mapdb} = $mapdb );
  $self->{_MarkerFeature_mapdb};
}

# compiled successfull

1;
