# BioPerl module for Bio::EnsEMBL::Map::MapMarkerI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 07.02.2000
# Last modified : 08.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::MapMarkerI

=head1 SYNOPSIS


=head1 DESCRIPTION

    Contains all the functionality of the MapMarker
    object, which the objects in the special driver direcories have to
    implement. (eg. DBSQL::MapMarker )

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::MapMarkerI;
use vars qw(@ISA);
use strict;


=head2 map

    Title   : map
    Usage   : $map = ...::MapMarker->map;

    Function: Give the MapI object this MapMarkerI belongs
    Example : $map = $mapMarker->map;

    Returns : -
    Args    : -

=cut


sub map {
    my $self = shift;
    $self->throw( "Function map not implemented in ".ref($self)."!" );
}

=head2 chromosomeMap

    Title   : chromosomeMap
    Usage   : $chrMap = ...::MapMarker->chromosomeMap;

    Function: Give the ChromosomeMapI object this MapMarkerI belongs to.
    Example : -

    Returns : -
    Args    : -

=cut

sub chromosomeMap {
    my $self = shift;
    $self->throw
	( "Function chromosomeMap not implemented in ".ref($self)."!" );
}

=head2 position_guess

    Title   : position_guess
    Usage   : ($start,$lenght) = ...::mapMarker->position_guess;

    Function: Gives an estimation where the marker starts and ends in
              basepairs on the DNA. Could be quite wrong. 
    Example : -

    Returns : a 2 element list with huge integer numbers.
    Args    : -

=cut

sub position_guess {
    my $self = shift;
    $self->throw
	( "Function position_guess not implemented in ".ref($self)."!" );
}


=head2 position

    Title   : position
    Usage   : $posI = ...::MapMarker->position;

    Function: Give the PositionI object, describing the position of the MapMarker in the Map.

    Example : -
    Returns : -
    Args    : -

=cut

sub position {
    my $self = shift;
    $self->throw( "Function position not implemented in ".ref($self)."!" );
}


=head2 marker

    Title   : marker
    Usage   : $marker = ...::MapMarker->marker;

    Function: Get the MarkerI object for this MapMarkerI. It contains the
    name and other nice functions for Markers.

    Example : -
    Returns : -
    Args    : -

=cut

sub marker {
    my $self = shift;
    $self->throw( "Function marker not implemented in ".ref($self)."!" );
}

# compiled successfull

1;
