# BioPerl module for Bio::EnsEMBL::Map::MapI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 05.02.2000
# Last modified : 09.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::MapI

=head1 SYNOPSIS


=head1 DESCRIPTION

    Contains all the functionality of the Map
    object, which the objects in the special driver direcories have to
    implement. (eg. DBSQL::Map )

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::MapI;
use vars qw(@ISA);
use strict;
use Bio::Root::RootI;



@ISA = qw( Bio::Root::RootI );


# Object preamble - inheriets from Bio::Root::Object

# new() is inherited from Bio::Root::Object
# _initialize is where the heavy stuff will happen when new is called

=head2 id

    Title   : id  
    Usage   : ...::MapI->id;
    Function: returns an id string for a Map
    Example : $map->id;
    Returns : 
    Args    : -

=cut

sub id {
    my ($self) = @_;
    $self->throw( "id not implemented in ".ref($self)."!" );
}

=head2 last_updated

    Title   : last_updated
    Usage   : $time  = ...::MapI->last_updated;
    Function: returns a string representaing the last update time of the
    Map in the database. 
    Example : -
    Returns : -
    Args    : -

=cut

sub last_updated {
    my ($self) = @_;
    $self->throw( "Function last_updated not implemented in ".ref( $self )."!" );
}

=head2 version

    Title   : version
    Usage   : $versionString  = ...::MapI->version;
    Function: Returns a version number or string representing a versioning
    system. 
    Example : -
    Returns : -
    Args    : -

=cut

sub version {
    my ($self) = @_;
    $self->throw( "Function version not implemented in ".ref( $self )."!" );
}

=head2 type

    Title   : type
    Usage   : $typeString  = ...::MapI->type;
    Function: Describes the type of map. Could be radiohybrid, genetic,
    cytogenetic, physical, sequence ...
    Example : -
    Returns : -
    Args    : -

=cut

sub type {
    my ($self) = @_;
    $self->throw( "Function type not implemented in ".ref( $self )."!" );
}

=head2 get_MapMarkers

    Title   : get_MapMarkers
    Usage   : $arrRefMapMarkers  = ...::MapI->get_MapMarkers;
    Function: return all MapMarkers for this MapI. Probably more than
    200000 objects have to be constructed if you call this!!
    Example : -
    Returns : -
    Args    : -

=cut

sub get_MapMarkers {
    my ($self) = @_;
    $self->throw( "Function get_MapMarkers not implemented in ".ref( $self )."!" );
}

=head2 get_ChromosomeMap

    Title   : get_ChromosomeMap
    Usage   : $chrMap  = ...::MapI->get_ChromosomeMap( string name);
    Function: Return a chromosomeMap object for the given name.
    Example : -
    Returns : exception, if there is no ChromosomeMap of that name. As well 
    if thats a Chromosome for which no MapMarkers are there!
    Args    : -

=cut

sub get_ChromosomeMap {
    my ($self) = @_;
    $self->throw( "Function get_ChromosomeMap not implemented in ".ref( $self )."!" );
}

=head2 get_ChromosomeNames

    Title   : get_ChromosomeNames
    Usage   : $arrRefNames  = ...::MapI->get_ChromosomeNames;
    Function: Gives a list of valid chromosome names in this Map.
    Example : -
    Returns : -
    Args    : -

=cut

sub get_ChromosomeNames {
    my ($self) = @_;
    $self->throw( "Function get_ChromosomeNames not implemented in ".ref( $self )."!" );
}




# compiled successfull

1;
