# BioPerl module for Bio::EnsEMBL::Map::LinearPositionI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 17.02.2000
# Last modified : 17.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::LinearPostionI

=head1 SYNOPSIS

=head1 DESCRIPTION

    A LinearPosition gives a number (float) on how far this position is
    away from the beginning of the DNA strand. For a radiation hybrid map
    this is the number of centirays(?).

=head1 CONTACT

    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::LinearPositionI;
use vars qw(@ISA);
use strict;
use Bio::EnsEMBL::Map::PositionI;

@ISA = qw( Bio::EnsEMBL::Map::PositionI );

=head2 coord

    Title   : coord
    Usage   : $float = ...::$linPos->coord;
    Function: Gives the float value for this position.
    Example : -
    Returns : -
    Args    : -

=cut

sub coord {
    my $self = shift;
    $self->throw( "Function coord is not implemented in ".ref($self)."!" );
}

# compiled successfull
1;

