# BioPerl module for Bio::EnsEMBL::Map::DBSQL::LinearPosition
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 21.02.2000
# Last modified : 21.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::DBSQL::LinearPosition

=head1 SYNOPSIS


=head1 DESCRIPTION

    An implementation of the PositionI interface that provides just a float 
    for a position.

=head1 CONTACT

    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::DBSQL::LinearPosition;
use vars qw(@ISA);
use strict;
use Bio::EnsEMBL::Map::LinearPositionI;

@ISA = qw( Bio::EnsEMBL::Map::LinearPositionI );

# Object preamble - inheriets from Bio::Root::Object

# new() is inherited from Bio::Root::Object
# _initialize is where the heavy stuff will happen when new is called
sub _initialize {
    my $self = shift;
    $self->SUPER::_initialize( @_ );
    my ( $position ) = @_;

    defined( $position ) || 
	$self->throw( "LinearPosition->new needs a float as argument");
    $self->{'_position'} = $position;
    $self;
}


=head2 

    Title   : id  
    Usage   : $linearPosition->id;
    Function: returns a string that describes this positon
    Example : -
    Returns : -
    Args    : -

=cut

sub id {
    my $self = shift;
    return $self->{'_position'};
}


sub coord {
    my $self = shift;
    return $self->{'_position'};
}


=head2 is_higher

    Title   : is_higher  
    Usage   : ...::$linearPositionObj->is_higher( $otherLinearPos ) ;
    Function: returns a boolean if this position is closer to p end than
    the given one.
    Example : -
    Returns : -
    Args    : -

=cut

sub is_higher {
    my $self = shift;
    my $otherPos = shift;

    $self->throw
	("is_higher(..) called with no argument LinearPositionI!")
	    unless ref($otherPos) &&
		$otherPos->isa( "Bio::EnsEMBL::Map::LinearPositionI");
    ( $self->_cmp( $otherPos ) == 1 );
}

=head2 is_lower

    Title   : is_lower  
    Usage   : ...::$linearPositionObj->is_lower( $otherLinearPos ) ;
    Function: returns a boolean if this position is farer to p end than
    the given one.
    Example : -
    Returns : -
    Args    : -

=cut

sub is_lower {
    my $self = shift;
    my $otherPos = shift;

    $self->throw
	("is_higher(..) called with no argument LinearPositionI!")
	    unless ref($otherPos) &&
		$otherPos->isa( "Bio::EnsEMBL::Map::LinearPositionI");
    ( $self->_cmp( $otherPos ) == -1 );
}


sub _cmp {
    my ( $self, $other ) = @_;

    $self->coord <=> $other->coord;
}
# compiled successfull

1;
