# BioPerl module for Bio::EnsEMBL::Map::DBSQL::FPC_Clone
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 23.05.2000
# Last modified : 31.05.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::DBSQL::FPC_Clone

=head1 SYNOPSIS

   @fpc_clone_list = $fpc_contig->get_sequenced_clones;

=head1 DESCRIPTION
   
     

=head1 CONTACT

    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::DBSQL::FPC_Clone;
use vars qw(@ISA);
use strict;

@ISA = qw( Bio::Root::Object );


# Object preamble - inheriets from Bio::Root::Object

# new() is inherited from Bio::Root::Object
# _initialize is where the heavy stuff will happen when new is called


=head2 Constructor

    Title   : _initialize
    Usage   : 
 Function: 
    Example :
    Returns : 
    Args    : 


=cut

sub _initialize {
  my $self = shift;
  my $name = shift;
  my $contig = shift;
  my $start = shift;
  my $length = shift;
  
  $self->{_fpc_contig} = $contig;
  $self->name( $name );
  $self->{_start} = $start;
  $self->{_length} = $length;
  $self;
}

sub get_Contig {
  my $self = shift;
  return $self->{'_fpc_contig'};
}


# relative to fpc_contig
# not accurate to calculate overlap
# careful with the numbers
sub get_Contig_Position {
  my $self = shift;
  return ( $self->{_start}, $self->{_length} );
}

sub position_estimate {
  my $self = shift;
  my $contig = $self->get_Contig;
  my @cpos = $contig->position_estimate;
  if( $#cpos == -1 ) {
    return ();
  };
  
  return ( $cpos[0]+$self->{_start}-1, $self->{_length} );
}

sub embl_acc {
  my $self = shift;
  my $embl_acc = shift;


  $embl_acc &&
    ( $self->{'_embl_acc'} = $embl_acc );
  #return 1;
  return $self->{'_embl_acc'};
}

sub name {
  my $self = shift;
  my $name = shift;

  $name &&
    ( $self->{_name} = $name );
  $self->{'_name'};
}

sub start {
    my( $self, $value ) = @_;
    
    if (defined $value) {
        $self->{'_start'} = $value;
    }
    return $self->{'_start'};
}

sub length {
    my( $self, $value ) = @_;
    
    if (defined $value) {
        $self->throw("length - read only parameter");
    }
    return $self->{'_length'};
}

sub end {
    my $self = shift;

    return $self->start + $self->length -1;
}


sub is_sequenced {
  my $self = shift;
  return ( defined $self->embl_acc );
}


# not supported yet
sub band_position {
  my $self = shift;
  $self->throw( "Not supported yet" );

}


sub sister_Clone_up {
  my $self = shift;
  my $result = 'Clone before';
  $self->throw( "Not supported yet" );
  return $result;
}

sub sister_Clone_down {
  my $self = shift;
  my $result = 'Clone after';
  $self->throw( "Not supported yet" );
  return $result;
}


