# BioPerl module for Bio::EnsEMBL::Map::DBSQL::ChromosomeBand
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 16.03.2000
# Last modified : 16.03.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::DBSQL::ChromosomeBand

=head1 SYNOPSIS


=head1 DESCRIPTION

    Some information for a ChromosomeBand.

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::DBSQL::ChromosomeBand;
use vars qw(@ISA);
use strict;
use Bio::EnsEMBL::Map::ChromosomeBandI;

# Object preamble - inheriets from Bio::Root::Object
@ISA = qw( Bio::EnsEMBL::Map::ChromosomeBandI );

=head2 new

    Title   : new
    Usage   : Called at construction
  Function: Makes a ChromosomeBand object from ( $name, $engthguess, $colour )
  Example :
    Returns:
    Args: ( $name, $lengthguess, $colour );
=cut

sub new {
    my ($class,@args) = @_;
    my $self = {};
    bless $self,$class;
    $self->SUPER::_initialize( @_ );
    $self->{'_name'} = shift;
    $self->{'_length'} = shift;
    $self->{'_colour'} = shift;
    if( !$self->{'_name'} || !$self->{'_length'} || !$self->{'_colour'} ) {
	$self->throw( "Initialize ChromosomeBand with name, length, colour!" );
    }
    # no paranoia for the time being
    return $self;
} 

=head2 name

    Title   : name
    Usage   : $name = $chromosomeBandI->name;
    Function: returns an name string for a ChromosomeBand
    Example : 
    Returns : 
    Args    : -

=cut

sub name {
    my $self = shift;
    $self->{'_name'};
}

=head2 length

    Title   : length
    Usage   : $length = $chromosomeBandI->length 
    Function: Returns a length guess for the ChromosomeBand in kB.
    Example : -
    Returns : -
    Args    : -

=cut

sub length {
    my ($self) = @_;
    $self->{'_length'};
}

=head2 position

    Title   : position
    Usage   : $pos = $chromomsomeBand->band_Position;
    Function: Returns a kb guess, where the Band starts in the Chromomome.
    Example : -
    Returns : -
    Args    : -

=cut

sub position {
    my ($self, $position) = @_;
    defined($position) && ( $self->{'_position'} = $position );
    $self->{'_position'};
}

=head2 colour

    Title   : colour
    Usage   : $colour = $chromosomeBandI->colour;
    Function: Returns a colour suggestion to draw the thing.
    Example : -
    Returns : -
    Args    : -

=cut

sub colour {
    my ($self, $colour) = @_;
    $colour && ( $self->{'_colour'} = $colour );
    $self->{'_colour'};
}


# compiled successfull

1;
