# BioPerl module for Bio::EnsEMBL::Map::ChromosomeMapI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 07.02.2000
# Last modified : 09.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::ChromosomeMapI

=head1 SYNOPSIS


=head1 DESCRIPTION

    Contains all the functionality of a ChromosomeMap
    object, which the objects in the special driver direcories have to
    implement. (eg. DBSQL::ChromosomeMap )

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::ChromosomeMapI;
use vars qw(@ISA);
use strict;
use Bio::Root::Object;

# Object preamble - inheriets from Bio::Root::Object
@ISA = qw( Bio::Root::Object );



=head2 name

    Title   : name  
    Usage   : ...::ChromosomeMapI->name;
    Function: returns an name string for a ChromosomeMap
    Example : $chrMap->name;
    Returns : 
    Args    : -

=cut

sub name {
    my ($self) = @_;
    $self->throw( "Function name not implemented in ".ref($self)."!");
}

=head2 get_MapMarkers

    Title   : get_MapMarkers
    Usage   : $arrRefMapMarkers = ...::ChromosomeMapI->get_MapMarkers;
    Function: Returns an array of MapMarker objects in this ChromosomeMap.
    Example : $arrayRefMapMarkers = $chrMap->get_MapMarkers;
    Returns : -
    Args    : -

=cut

sub get_MapMarkers {
    my ($self) = @_;
    $self->throw( "Function get_MapMarkers not implemented in ".ref($self)."!");
}

=head2 get_Map

    Title   : get_Map
    Usage   : $map = ...::ChromosomeMapI->get_Map;
    Function: Returns the Map in which this ChromosomeMap is.
    Example : -
    Returns : -
    Args    : -

=cut

sub get_Map {
    my ($self) = @_;
    $self->throw( "Function get_Map not implemented in ".ref($self)."!");
}

=head2 next_MapMarker

    Title   : next_MapMarker
    Usage   : $mapMarker = ...::ChromosomeMapI->next_MapMarker( $oldMapMarker );
    Function: Returns the next MapMarker following the given one.
    Example : -
    Returns : Throws exception if there is no next one.
    Args    : -

=cut

sub next_MapMarker {
    my ($self) = @_;
    $self->throw( "Function next_MapMarker not implemented in ".ref($self)."!");
}

=head2 prev_MapMarker

    Title   : prev_MapMarker
    Usage   : $mapMarker = ...::ChromosomeMapI->prev_MapMarker( $oldMapMarker );
    Function: Returns the MapMarker before the given one.
    Example : -
    Returns : Throws exception if there is no previous one.
    Args    : -

=cut

sub prev_MapMarker {
    my ($self) = @_;
    $self->throw( "Function prev_MapMarker not implemented in ".ref($self)."!");
}


# compiled successfull

1;
