# BioPerl module for Bio::EnsEMBL::Map::ChromosomeI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 16.03.2000
# Last modified : 16.03.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::ChromosomeI

=head1 SYNOPSIS


=head1 DESCRIPTION

    Some general Information from a Chromosome.

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::ChromosomeI;
use vars qw(@ISA);
use strict;
use Bio::Root::Object;

# Object preamble - inheriets from Bio::Root::Object
@ISA = qw( Bio::Root::Object );



=head2 name

    Title   : name
    Usage   : $name = $chromosomeI->name;
    Function: returns an name string for a Chromosome
    Example : 
    Returns : 
    Args    : -

=cut

sub name {
    my ($self) = @_;
    $self->throw( "Function name not implemented in ".ref($self)."!");
}

=head2 length

    Title   : length
    Usage   : $length = $chromosomeI->length 
    Function: Returns a length guess for the Chromosome in kB.
    Example : -
    Returns : -
    Args    : -

=cut

sub length {
    my ($self) = @_;
    $self->throw( "Function length not implemented in ".ref($self)."!");
}

=head2 band_Count

    Title   : band_Count
    Usage   : $num = $chrMap->band_Count;
    Function: Returns the number of visible Bands in the Chromosome.
    Example : -
    Returns : -
    Args    : -

=cut

sub band_Count {
    my ($self) = @_;
    $self->throw( "Function band_Count not implemented in ".ref($self)."!");
}

=head2 get_Band

    Title   : get_Band
    Usage   : $chromomsomeBandI = $chromosomeI->get_Band( $num );
    Function: Returns the n-th band/subband as ChromosomeBandI object.
    Example : -
    Returns : undef if not possible.
    Args    : -

=cut

sub get_Band {
    my ($self) = @_;
    $self->throw( "Function get_Band not implemented in ".ref($self)."!");
}


# compiled successfull

1;
