# BioPerl module for Bio::EnsEMBL::Map::ChromosomeBandI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 16.03.2000
# Last modified : 16.03.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::ChromosomeBandI

=head1 SYNOPSIS


=head1 DESCRIPTION

    Some information for a ChromosomeBand.

=head1 CONTACT


    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk


=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::ChromosomeBandI;
use vars qw(@ISA);
use strict;
use Bio::Root::RootI;

# Object preamble - inheriets from Bio::Root::Object
@ISA = qw( Bio::Root::RootI );



=head2 name

    Title   : name
    Usage   : $name = $chromosomeBandI->name;
    Function: returns an name string for a ChromosomeBand
    Example : 
    Returns : 
    Args    : -

=cut

sub name {
    my ($self) = @_;
    $self->throw( "Function name not implemented in ".ref($self)."!");
}

=head2 length

    Title   : length
    Usage   : $length = $chromosomeBandI->length 
    Function: Returns a length guess for the ChromosomeBand in kB.
    Example : -
    Returns : -
    Args    : -

=cut

sub length {
    my ($self) = @_;
    $self->throw( "Function length not implemented in ".ref($self)."!");
}

=head2 position

    Title   : position
    Usage   : $pos = $chromomsomeBand->band_Position;
    Function: Returns a kb guess, where the Band starts in the Chromomome.
    Example : -
    Returns : -
    Args    : -

=cut

sub position {
    my ($self) = @_;
    $self->throw( "Function position not implemented in ".ref($self)."!");
}

=head2 colour

    Title   : colour
    Usage   : $colour = $chromosomeBandI->colour;
    Function: Returns a colour suggestion to draw the thing.
    Example : -
    Returns : -
    Args    : -

=cut

sub colour {
    my ($self) = @_;
    $self->throw( "Function colour not implemented in ".ref($self)."!");
}


# compiled successfull

1;
