# BioPerl module for Bio::EnsEMBL::Map::BandedPositionI
#
# Creator: Arne Stabenau <stabenau@ebi.ac.uk>
# Date of creation: 09.02.2000
# Last modified : 09.02.2000 by Arne Stabenau
#
# Copyright EMBL-EBI 2000
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Map::BandedPostionI

=head1 SYNOPSIS


=head1 DESCRIPTION

    A BandedPosition is a position on a CytogeneticMap. It has start and
    end major band numbers plus start and end minor band numbers. The
    majors have indication wether they are on the long or short arm 
    of they chromosome (p and q). 


=head1 CONTACT

    Contact Arne Stabenau on implemetation/design detail: stabenau@ebi.ac.uk
    Contact Ewan Birney on EnsEMBL in general: birney@sanger.ac.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods. Internal methods are usually preceded with a _

=cut


# Let the code begin...


package Bio::EnsEMBL::Map::BandedPositionI;
use vars qw(@ISA);
use strict;
use Bio::EnsEMBL::Map::PositionI;

@ISA = qw( Bio::EnsEMBL::Map::PositionI );

sub start_band {
    my $self = shift;
    $self->throw( "Function start_band is not implemented in ".ref($self)."!" );
}

sub end_band {
    my $self = shift;
    $self->throw( "Function end_band is not implemented in ".ref($self)."!" );
}

sub start_sub_band {
    my $self = shift;
    $self->throw( "Function start_sub_band is not implemented in ".ref($self)."!" );
}

sub end_sub_band {
    my $self = shift;
    $self->throw( "Function end_sub_band is not implemented in ".ref($self)."!" );
}



# compiled successfull

1;
