package Bio::EnsEMBL::GlyphSet::ssr_label;
use strict;
use vars qw(@ISA);
use Bio::EnsEMBL::GlyphSet;
use Bio::EnsEMBL::Glyph::Rect;
use Bio::EnsEMBL::Glyph::Intron;
use Bio::EnsEMBL::Glyph::Text;
use Bio::EnsEMBL::Glyph::Composite;
use Bump;

@ISA = qw(Bio::EnsEMBL::GlyphSet);

sub _init {
    my $self = shift;
    my $VirtualContig = $self->{'container'};
    my $Config = $self->{'config'};
    
    my $pix_per_bp  = $Config->transform->{'scalex'};
    my $bitmap_length = int($VirtualContig->length * $pix_per_bp);
    my @bitmap;

    return unless ($self->strand() == -1);

    my $feature_colour 	= $Config->get($Config->script(),'marker','col');
    my $fontname = "Tiny";
    my ($w,$h) = $Config->texthelper->px2bp($fontname);
    $w = $Config->texthelper->width($fontname);

    my @xf=$VirtualContig->get_all_ExternalFeatures();
	
    foreach my $f (@xf){
	    my $fp='notFP';
	    if ($f->isa("Bio::EnsEMBL::FeaturePair")) {
		$fp='FP';
		next if ($f->analysis->db ne 'ssr' ) ; #Not ours
	    } else {
	        next;
	    }
	#should have next if blah blah blah but don't need it yet
	my $fid = $f->id();
	my $bp_textwidth = $w * length("$fid ");
	my $glyph = new Bio::EnsEMBL::Glyph::Text({
		'x'	    => $f->start(),
		'y'	    => 0,
		'height'    => $Config->texthelper->height($fontname),
		'font'	    => $fontname,
		'colour'    => $feature_colour,
		'absolutey' => 1,
		'text'	    => $fid,
		});

	##############
    	# bump-tastic
	#
    	my $bump_start = int($glyph->x() * $pix_per_bp);
	$bump_start    = 0 if ($bump_start < 0);

    	my $bump_end = $bump_start + $bp_textwidth;
    	next if $bump_end > $bitmap_length;
    	my $row = &Bump::bump_row(      
	    $bump_start,
	    $bump_end,
	    $bitmap_length,
	    \@bitmap
    	);

    	$glyph->y($glyph->y() + (1.2 * $row * $h));
    	$self->push($glyph);
    }	
}

1;
