package Bio::EnsEMBL::GlyphSet::ssr;	#ssr  Marker
use strict;
use vars qw(@ISA);
use SiteDefs qw/:URL/;
use Bio::EnsEMBL::GlyphSet;
@ISA = qw(Bio::EnsEMBL::GlyphSet);
use Bio::EnsEMBL::Glyph::Rect;
use Bio::EnsEMBL::Glyph::Intron;
use Bio::EnsEMBL::Glyph::Text;
use Bio::EnsEMBL::Glyph::Composite;
use Bump;

sub init_label {
    my ($this) = @_;

    my $label = new Bio::EnsEMBL::Glyph::Text({
	'text'      => 'SSR Marker',
	'font'      => 'Small',
	'absolutey' => 1,
    });
    $this->label($label);
}

sub _init {
    my ($self) = @_;

    return unless ($self->strand() == -1);

    my $VirtualContig = $self->{'container'};
    my $Config        = $self->{'config'};
    my $y             = 0;
    my $h             = 8;
    my $highlights    = $self->highlights();
    my $marker_col     = $Config->get($Config->script(),'ssr','col');

    my @bitmap      = undef;
    my $pix_per_bp  	= $Config->transform()->{'scalex'};
    my $im_width = $Config->image_width();
    my $bitmap_length = $VirtualContig->length();
    my @xf=$VirtualContig->get_all_ExternalFeatures();
    my $urls = ExtURL->new;
	my @marker;
	
    foreach my $f (@xf){
	    my $fp='notFP';
	    if ($f->isa("Bio::EnsEMBL::FeaturePair")) {
		    $fp='FP';
		    if ($f->analysis->db eq 'ssr' ) { 
				    #print SDTERR "$f\n"
			push (@marker, $f);
		    }
	    }	
	    #print STDERR $f->id,":$fp ",$f->analysis->dbID,',',$f->analysis->db,"\n";
    }

    my $rect;
    my $colour;
    foreach my $s (@marker) {
	my $x = $s->start();
	my $x1 = $s->end();
	my $id = $s->id();
	(my $idl=$id) =~ s/\..*//;
	#print STDERR "Trace start: ", $x, " ID:", $s->id(),  "\n";
	my $markerglyph = new Bio::EnsEMBL::Glyph::Rect({
		'x'      => $x,
		'y'      => 0,
		'width'  => $x1-$x,
		'height' => $h,
		'colour' => $marker_col,
		'absolutey'  => 1,
		'zmenu'     => { 
			'caption' => "$id",
			'Marker info' => 
			$ENSEMBL_EXTERNAL_URLS->{'GRAMENE_HOME'}."/gramene/map/marker?name=$idl&class=Marker"
			#,'Marker sequence' => 
			#$urls->get_url('EMBL', $s->hseqname)
		},
	});
	if ($Config->get($Config->script(), 'ssr', 'dep') > 0){ # we bump
	    my $bump_start = int($markerglyph->x() * $pix_per_bp);
	    $bump_start = 0 if ($bump_start < 0);

	    my $bump_end = $bump_start + ($markerglyph->width() * $pix_per_bp);
	    $bump_end=$bitmap_length-int($bitmap_length-$bump_end);
	    if ($bump_end > $bitmap_length){$bump_end = $bitmap_length};
	    my $row = &Bump::bump_row(      
				      $bump_start,
				      $bump_end,
				      $bitmap_length,
				      \@bitmap
	    );

	    next if $row > $Config->get($Config->script(), 'ssr', 'dep');
	    $markerglyph->y($markerglyph->y() + (1.5 * $row * $h ));

	    ## if we are bumped && on a large contig then draw frames around features....
	    #$markerglyph->bordercolour($feature_colour) unless ($small_contig);
	}
	$self->push($markerglyph);
    }

}

1;
