package Bio::EnsEMBL::GlyphSet::est;
use strict;
use vars qw(@ISA);
use Bio::EnsEMBL::GlyphSet;
@ISA = qw(Bio::EnsEMBL::GlyphSet);
use Bio::EnsEMBL::Glyph::Rect;
use Bio::EnsEMBL::Glyph::Intron;
use Bio::EnsEMBL::Glyph::Text;
use Bio::EnsEMBL::Glyph::Composite;
use Bump;

sub init_label {
    my ($this) = @_;
    my $Config          = $this->{'config'};
    my $track 		= $this->{'row'};

    return '' unless $Config;
    my $label = new Bio::EnsEMBL::Glyph::Text({
	'text'      => $Config->get($Config->script(),$track,'text'),
	'font'      => 'Small',
	'absolutey' => 1,
    });
    $this->label($label);
}

sub _init {
    my ($self) = @_;
    my $VirtualContig   = $self->{'container'};
    my $Config          = $self->{'config'};
    my $strand          = $self->strand();
    my $y               = 0;
    my $h               = 8;
    my $highlights      = $self->highlights();
    my $track 		= $self->{'row'};
    my $feature_colour  = $Config->get($Config->script(),$track,'col');
    my $feature  	= $Config->get($Config->script(),$track,'feature');
    my $score	  	= $Config->get($Config->script(),$track,'score') || 80;
    my $linkout            = $Config->get($Config->script(),$track,'linkout');
    %$linkout=() unless $linkout;
    my @bitmap          = undef;
    my $pix_per_bp  	= $Config->transform()->{'scalex'};
    my $bitmap_length 	= int($VirtualContig->length * $pix_per_bp);
    my $small_contig    = 0;

    my $glob_bp = 100;
    my @allfeatures = $VirtualContig->get_all_SimilarityFeatures_above_score($feature,$score); #,$glob_bp);  

#    print STDERR "$track:",scalar(@allfeatures),"\n";
	
	my %id = ();

#	if(@allfeatures) { my $f=$allfeatures[0];
#	    no strict;
#	    print STDERR $f->id," is ",ref($f),"\n";
#	    my @try=qw(
#		all_tags 
#		end 
#		entire_seq frame id
#		hend 
#		hseqname hstart hstrand
#		raw_end
 
#		raw_seqname raw_start 
#		seq seqname start strand
#	    );
#	    foreach my $m (@try) {
#	        next unless $f->can($m);
#		my $x=$f->$m;
#		print STDERR "->",$m,"=$x is ",ref($x),"\n";
#	    }
#	    foreach my $p (feature1,feature2) {
#	        next unless $f->can($p);
#		my $ff=$f->$p;
#		foreach my $m (@try) {
#		    next unless $ff->can($m);
#		    my $x=$ff->$m;
#		    print STDERR "->",$p,"->",$m,"=$x is ",ref($x),"\n";
#		}
#	    }
#	}
	

 
        foreach my $f (@allfeatures){
	  #print STDERR "$track ",$f->id(),"\n";
	    #next unless ($f->strand() == $strand);
	    unless ( $id{$f->id()} ){
		    $id{$f->id()} = [];
	    }
	    push(@{$id{$f->id()}}, $f );
	}
	#print STDERR "ids: ",scalar(keys %id),"\n";
	foreach my $i (keys %id){
	    my $has_origin = undef;
	    my %current_linkout=();
	    foreach my $key (keys %$linkout){
	      my $link_url= $linkout->{$key};
	      $link_url=~s/FEATUREID/$i/;
	      $current_linkout{$key}=$link_url;
	    }
	    my %zmenu=( 'caption' => "$i",
			   # "GenBank" => "http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=$i",
			    %current_linkout,
		     );
	    my $Composite = new Bio::EnsEMBL::Glyph::Composite({
			'zmenu'     => { %zmenu},
	    });

	    @{$id{$i}} =  sort {$a->start() <=> $b->start() } @{$id{$i}};
	    foreach my $f (@{$id{$i}}){
		unless (defined $has_origin){
		    $Composite->x($f->start());
		    $Composite->y(0);
		    $has_origin = 1;
		}
		
		$Composite->bordercolour($feature_colour);

		#print STDERR "Feature start: ", $f->start(), " ID:", $f->id(),  "\n";
		#print STDERR "Feature length: ", $f->length() ,  "\n";
		my $glyph = new Bio::EnsEMBL::Glyph::Rect({
			'x'      	=> $f->start(),
			'y'      	=> 0,
			'width'  	=> $f->length(),
			'height' 	=> $h,
			'colour' 	=> $feature_colour,
			'absolutey' => 1,
			'_feature' 	=> $f, 
		});
		#print STDERR "Adding ", $f->id(), " to composite glyph ...\n";
		$Composite->push($glyph);
	    }
	    
#	we told the composite to have a border and so don't need to do this:
#	    # loop through glyphs again adding connectors...
#	    my @g = $Composite->glyphs();
#	    for (my $ig = 1; $ig<scalar(@g); $ig++){
#		    my $hstart  = $g[$ig]->{'_feature'}->hstart();
#		    my $hend    = $g[$ig-1]->{'_feature'}->hend();
#		    my $fstart  = $g[$ig-1]->{'_feature'}->start();
#		    my $flength = $g[$ig-1]->{'_feature'}->length();
#
#		    print STDERR "$prefix Last end   = ", $hend, "\n";
#		    print STDERR "$prefix Next start = ", $hstart, "\n";
#		    print STDERR "$prefix Difference = ", $hstart - $hend, "\n";
#		    
#		    $Composite->{'zmenu'}->{"[Intron $ig] bp $hend - $hstart"} = '';
#		    for $j (0,1) {
#			my $intglyph = new Bio::EnsEMBL::Glyph::Line({
#			    'x'      	=> $fstart + $flength,
#			    'y'      	=> $h * $j,
#			    'width'  	=> $g[$ig]->{'_feature'}->start() - ($fstart + $flength),
#			    'height' 	=> 0,
#			    'colour' 	=> $feature_colour,
#			    'dotted'	=> 0,
#			    'absolutey' => 1,
#			});
#			$Composite->push($intglyph);
#		    }
#	    }
	    
#	    print STDERR "dep=",$Config->get($Config->script(), $track, 'dep'),"\n";
	    if ($Config->get($Config->script(), $track, 'dep') > 0){ # we bump
		my $bump_start = int($Composite->x() * $pix_per_bp);
		$bump_start = 0 if ($bump_start < 0);

		my $bump_end = $bump_start + ($Composite->width() * $pix_per_bp);
		if ($bump_end > $bitmap_length){$bump_end = $bitmap_length};
		my $row = &Bump::bump_row(      
					  $bump_start,
					  $bump_end,
					  $bitmap_length,
					  \@bitmap
		);

		next if $row > $Config->get($Config->script(), $track, 'dep');
		$Composite->y($Composite->y() + (1.5 * $row * $h * -$strand));

		    # if we are bumped && on a large contig then draw frames around features....
		    #$Composite->bordercolour($feature_colour) unless ($small_contig);
	    }
	    
	    # now save the composite glyph...
	    $self->push($Composite);
	}
	
}

1;
