#!/lab/bin/perl

use strict;

use lib $ENV{'GrameneCodeDir'}."/lib/perl";

use Getopt::Long;
use DB_File;
use DBI;
use CSHL::Config;


my $dbfile='';
my $db;

GetOptions("translate=s"=>\$dbfile,"database=s"=>\$db) or usage();

sub usage {
    print STDERR "usage: $0 --database [Old]{Sequence|Ontology|Map} [ --translate DBFILE ] [control_file ... control_file ]\n",
    	( @_ ? join("\n",@_)."\n" : '');
    exit 1;
}

my %translate;
if($dbfile) {
    tie %translate,'DB_File',$dbfile , O_RDONLY , 0664 , $DB_HASH or usage("$dbfile:$!");
}

#need to open database
$db=~/^(Old)?(Sequence|Ontology|Map)$/ or usage("database $db ?");

my $dbh;

#print  '$dbh=DBI->connect('.$db.'DataSource,'.$db.'DBUser,'.$db.'DBPassword)' ,"\n";
eval  '$dbh=DBI->connect('.$db.'DataSource,'.$db.'DBUser,'.$db.'DBPassword)' or die "Database connect:$!,$@,$DBI::errstr";

my @translate_cols;


=head1 Control File

to separate by space, use \040

=cut

while(<>) {
    chomp;
#exon.dat , exon !id contig version created modified seq_start seq_end strand phase end_phase sticky_rank
    /^\s*#/ and next;

    my($outfile,$sep,$table,@columns)=split;

    @columns or print STDERR "$ARGV: No columns: $_\n" and next ;

    if(length($sep)>1 && $sep ne 'END' ) {	 #!! interpret it
	$sep=eval "<<END;\n$sep\nEND\n";
	chomp $sep;
    }

    $sep or print STDERR "$ARGV: No separator: $_\n" and next;

    for my $i (0..$#columns)  {
	push @translate_cols,$i if $columns[$i]=~s/^!//;
    }
    if(scalar(@translate_cols) and ! $dbfile) {
        print STDERR "Warning: translation requested on column(s) ",join(",",$columns[@translate_cols])," but no translation dbfile given";
	@translate_cols=();
    }

    open OUTFILE,">$outfile" or print STDERR "opening $outfile:$!\n" and next;

    my $query="select ".join(",",@columns)." from $table order by ".$columns[0];
    my $sth=$dbh->prepare($query) or print STDERR "$query:$DBI::errstr\n" and next;
    $sth->execute or print STDERR "$query:$DBI::errstr\n" and next;
    while(my $res=$sth->fetchrow_arrayref) {
	foreach my $i (@translate_cols) {
	    $res->[$i]= $translate{$res->[$i]} if exists $translate{$res->[$i]} ;
	}
        print OUTFILE join($sep,@$res),"\n";
    }

    close OUTFILE;

}
