#!/lab/bin/perl

use strict;

use lib $ENV{'GrameneCodeDir'}."/lib/perl";

use Getopt::Long;
use DB_File;
use DBI;
use CSHL::Config;


my $db;
my $exclude;
my $filestem='resources';

GetOptions("exclude"=>\$exclude,"database=s"=>\$db,"file=s"=>\$filestem) or usage();

sub usage {
    print STDERR "usage: $0 [ --database={Old|Current}] [--exclude ] [ --file=filestem ]\n",
    	" Default database=Current, --exclude means exclude identifiers in the other database.\n",
	" Default filestem=resources\n",
    	( @_ ? join("\n",@_)."\n" : '');
    exit 1;
}

my $site='http://www.gramene.org/';
my $icon=$site.'images/icons/gramene_button.png';
my $ourproviderid=3769;

# Remember to quote  &  in the query
my @links = (
    { script => "/perl/contigview", 
      params => "clone=",
      GenbankDB => "Nucleotide",
      query => "select id from clone where htg_phase>1",
      label => "clone",
      description => "<UrlName>Genome Viewer</UrlName>",
    },
    { script => "/perl/unisearch", 
      params => "type=marker&amp;q=",
      GenbankDB => "Nucleotide",
      query => "select distinct(marker_accession) from marker_clone where marker_accession is not null",
      label => "marker",
      description => "<UrlName>Genome &amp; Comparative Map Viewers</UrlName>",
    },
    { script => "/perl/geneview", 
      params => "gene=",
      GenbankDB => "Protein",
      query => "select xref.display_id from xref,objectxref,externaldb where 
		 xref.xrefid=objectxref.xrefid and 
		 objectxref.ensembl_object_type = 'Translation'
		 and xref.externaldbid=externaldb.externaldbid and externaldb.db_name='ENTREZPRO'",
      label => "gene",
      description => "<UrlName>Genome Viewer &amp; Protein Properties</UrlName>",
    },

);
# -- The description includes the markup because it could alternatively be a SubjectType
#     or be lacking

#open database(s)
$db = '' if $db eq 'Current';
my $excludedb;
if ( $db eq 'Old' ) {
    $excludedb='';
} else {
    usage("database $db ?") if $db;
    $excludedb='Old';
}
$db .='Sequence';
$excludedb .='Sequence';

my ($dbh,$excludedbh);

eval  '$dbh=DBI->connect('.$db.'DataSource,'.$db.'DBUser,'.$db.'DBPassword)' or die "Database connect:$!,$@,$DBI::errstr";
eval  '$excludedbh=DBI->connect('.$excludedb.'DataSource,'.$excludedb.'DBUser,'.$excludedb.'DBPassword)' 
	    or die "Exclude Database connect:$!,$@,$DBI::errstr" 
	if $exclude;

my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = localtime(time);
my $today=sprintf("%02d%02d%d",$mon+1,$mday,1900+$year);
foreach my $link (@links) {
    my $outfile="$filestem.".$link->{'label'}.".$today.xml";
    my $linkid=$link->{'label'}."_$today";
    open OUTFILE,">$outfile" or print STDERR "opening $outfile:$!\n" and next;

    my %exclude;
    if ($exclude) {
	my $exres=$excludedbh->selectcol_arrayref($link->{'query'}) or print STDERR "Exclude:".$link->{'query'}.":$DBI::errstr\n" and next;
	%exclude=map { ($_,1) } @$exres;
    }
    my $res=$dbh->selectcol_arrayref($link->{'query'}) or print STDERR $link->{'query'}.":$DBI::errstr\n" and next;

    my ( $script, $params, $GenbankDB, $description)= @$link{('script','params','GenbankDB','description')};

    print OUTFILE <<END_HEAD ;
<!DOCTYPE LinkSet PUBLIC "-//NLM//DTD LinkOut 1.0//EN" "LinkOut.dtd"
[ <!ENTITY icon.url CDATA "$icon">
<!ENTITY base.url CDATA "$site$script?"> ]>
<LinkSet>
    <Link>
        <LinkId>$linkid</LinkId>
        <ProviderId>$ourproviderid</ProviderId>
        <IconUrl>&icon.url;</IconUrl>
        <ObjectSelector>
            <Database>$GenbankDB</Database>
            <ObjectList>
END_HEAD

    if($exclude) {
	print OUTFILE map { "<Query>${_}[pacc]</Query>\n" } grep { ! exists $exclude{$_} } @$res;
    } else {
	print OUTFILE map { "<Query>${_}[pacc]</Query>\n" } @$res;
    }

    print OUTFILE <<END_TRAIL;
             </ObjectList>
        </ObjectSelector>
        <ObjectUrl>
            <Base>&base.url;</Base>
            <Rule>$params&lo.pacc;</Rule>
	    $description
        </ObjectUrl>
     </Link>

 </LinkSet>
END_TRAIL

    close OUTFILE;

}



