#!/usr/local/bin/perl 

use strict;
use warnings;

use lib qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use CSHL::Config;
use Bio::SeqIO;
use Bio::EnsEMBL::DBLoader;



    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator );
 
    my $gene_dbobj=$db->gene_Obj;

    my @genes=@ARGV;
    @genes or @genes=$gene_dbobj->get_all_Gene_id();

    my %count;

    my $seqio = new Bio::SeqIO(-format => 'fasta',
				 -fh     => \*STDOUT);



    foreach my $geneid (@genes) {
	#print "! $geneid\n";
        my $gene=$gene_dbobj->get($geneid);
		#$gene_adaptor->fetch_by_dbID($geneid);	#$db->get_Gene($geneid);
	my @exons=();
	my (%clones,$strand,@gb_seq);

	my ($gb_seq,$gbid)=(undef,undef);

	foreach my $trans ($gene->each_Transcript) {
	    my $pep=$trans->translate();
	     $seqio->write_seq($pep);
	}
    }



