#!/usr/local/bin/perl -w
###############################################################################
#   
#   Name:           SiteDefs.pm
#   
#   Description:    Localisation config for Ensembl website.
#
###############################################################################

package SiteDefs;
use strict;
use vars qw(    @ISA 
                @EXPORT 
                @EXPORT_OK 
                %EXPORT_TAGS 
                $VERSION
                $ENSEMBL_SERVERROOT
                $ENSEMBL_PREFIX
                $ENSEMBL_PREFIXE
                $ENSEMBL_PREFIXT
                $ENSEMBL_PREFIXG
                $ENSEMBL_PREFIXP
		$ENSEMBL_DRIVER
                $ENSEMBL_HOST
                $ENSEMBL_HOST_PORT
                $ENSEMBL_DB
                $ENSEMBL_MAP
                $ENSEMBL_GMAP
                $ENSEMBL_EMBL
                $ENSEMBL_DISEASE
                $ENSEMBL_EXPRESSION
		$ENSEMBL_SNP
                $ENSEMBL_FAMILY
                $ENSEMBL_TRACE_MOUSE
                $ENSEMBL_MOUSE
                $ENSEMBL_HELP
                $ENSEMBL_HELP_HOST
                $ENSEMBL_HELP_PORT
                $ENSEMBL_HELP_DBUSER
                $ENSEMBL_HELP_DBPASS
                $ENSEMBL_DBUSER
                $ENSEMBL_DBPASS
                $ENSEMBL_SEARCH
                $ENSEMBL_SERVER
                $ENSEMBL_ORACLE_BASE
                $ENSEMBL_ORACLE_SID
                $ENSEMBL_ORACLE_HOME
                $ENSEMBL_TWO_TASK
                $ENSEMBL_TNS_ADMIN
		$ENSEMBL_GOLD
                $ENSEMBL_PORT
                $ENSEMBL_USER
                $ENSEMBL_GROUP
                $ENSEMBL_SERVERADMIN
                $ENSEMBL_SERVERNAME
                $ENSEMBL_MAIL_ERRORS
                $ENSEMBL_ERRORS_TO
                $ENSEMBL_EXTERNAL_INDEXERS
                $ENSEMBL_EXTERNAL_DATABASES
		$ENSEMBL_EXTERNAL_URLS
		$EMBOSSBIN
                );
use Sys::Hostname;
use Exporter();
@ISA=qw(Exporter);

$VERSION=1.01;

###############################################################################
####################### LOCAL CONFIGURATION VARIABLES #########################
###############################################################################

##########################################################################
# You need to change the following server root setting.  It points to the
# directory that contains htdocs, modules, perl, ensembl, etc
#
# DO NOT LEAVE A TRAILING '/' ON ENSEMBL_SERVERROOT
##########################################################################
$ENSEMBL_SERVERROOT = '/usr/local/apache';

$ENSEMBL_PREFIX         = 'GRM';	    # ensembl gene id prefix
$ENSEMBL_PREFIXE        = 'GRME';	    # ensembl exon id prefix
$ENSEMBL_PREFIXT        = 'GRMT';	    # ensembl transcript id prefix
$ENSEMBL_PREFIXG        = 'GRMG';	    # ensembl gene id prefix
$ENSEMBL_PREFIXP        = 'GRMP';	    # ensembl translation id prefix
#$ENSEMBL_PREFIX        = 'COB';            # ensembl temporary gene id prefix
$ENSEMBL_DRIVER		= 'Oracle';	    # ensembl database driver
$ENSEMBL_HOST           = 'ServerE';      # ensembl database server
$ENSEMBL_HOST_PORT	= '1521';	    # ensembl database port (Oracle)
$ENSEMBL_DB             = 'gramene';	    # ensembl database name
$ENSEMBL_EMBL           = '';	    # ensembl database name
$ENSEMBL_MAP            = ''; #'rice,user=maps';	    # maps database name
$ENSEMBL_GMAP            = 'gramene'; # Gramene maps database name
$ENSEMBL_DISEASE        = '';	    # disease database name
$ENSEMBL_EXPRESSION     = '';  # sage database name
$ENSEMBL_SNP            = '';	    # snp database name
$ENSEMBL_FAMILY         = '';	    # family database name
$ENSEMBL_TRACE_MOUSE   = '';	    # mouse trace tcore database name
$ENSEMBL_MOUSE		= '';	    # mouse exonerate database name
$ENSEMBL_HELP           = 'gramene';    # help database name
$ENSEMBL_HELP_HOST      = 'ServerE';      # help database name
$ENSEMBL_HELP_PORT	= '1521';	    # help database port
$ENSEMBL_HELP_DBUSER    = 'Sequence1';	    # help database name
$ENSEMBL_HELP_DBPASS    = 'PASSWORD';	    # help database name

$ENSEMBL_DBUSER         = 'Sequence1';         # database username
$ENSEMBL_DBPASS         = 'PASSWORD';	    # database password
$ENSEMBL_SEARCH         = 'unisearch';      # script to use for search
$ENSEMBL_SERVER         = Sys::Hostname::hostname();  # Local machine name
$ENSEMBL_ORACLE_HOME    = '/oracle1/app/oracle/product/9.0.1.1';
$ENSEMBL_ORACLE_BASE    = '/oracle1/app/oracle';
$ENSEMBL_ORACLE_SID     = 'gramene';
$ENSEMBL_TWO_TASK       = 'T:localhost:gramene';
$ENSEMBL_TNS_ADMIN      = '/oracle1/app/oracle/product/9.0.1.1/network/admin';

$ENSEMBL_GOLD		= 'CUGI';	#default static golden path type

$EMBOSSBIN		= '/usr/local/bin';	#location of Emboss pgms like pepstats

###############
# Web Settings
###############

$ENSEMBL_PORT           = 80;
$ENSEMBL_USER           = 'nobody';
$ENSEMBL_GROUP          = 'nobody';
$ENSEMBL_SERVERADMIN    = 'gramene&#064;gramene.org';
$ENSEMBL_SERVERNAME     = 'ServerE.cshl.org';
						
$ENSEMBL_MAIL_ERRORS    = 1;			# Do we want to email errors?
						# Who do we mail errors to?
$ENSEMBL_ERRORS_TO      = 'schmidt@cshl.org';

#######################
# External DB Indexers
#######################
$ENSEMBL_EXTERNAL_DATABASES={
                            'EMBL'      =>  'NULL',
                            'EMBLNEW'   =>  'NULL',
                            'SPTREMBL'  =>  'NULL',
                            'TREMBLNEW' =>  'NULL',
                            'SWIR'      =>  'NULL',
			    'SWISSPROT'	=>  'NULL',
                            'TREMBL'    =>  'NULL',
                            'PFAM'      =>  'NULL',
                            };

$ENSEMBL_EXTERNAL_INDEXERS={
                            'PFETCH'    =>  '/usr/local/pubseq/bin/pfetch',
                            'EFETCH'    =>  '/usr/local/pubseq/bin/efetch',
                            'SRS'       =>  '/usr/local/pubseq/bin/getz',
			    'NULL'	=> '',
                            };
			   

#######################
# External DB Indexers
#######################
$ENSEMBL_EXTERNAL_URLS=	{
    'NULL'	    => '',
    'DS'	    => 'http://carbon.wi.mit.edu:8000/cgi-bin/contig/sts_info?sts=###ID###',
    'ENTREZPRO'     => 'http://www.ncbi.nlm.nih.gov/entrez/viewer.cgi?val=###ID###',
    'EMBL'	    => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=###ID###',
    			#'http://www.ebi.ac.uk/cgi-bin/emblfetch?###ID###',
    'EMBL_AC'	    => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=###ID###',
    			#'http://www.ebi.ac.uk/cgi-bin/emblfetch?###ID###',
    'EMBL_PROT_AC'  => 'http://srs6.ebi.ac.uk/srs6bin/cgi-bin/wgetz?-e+[libs%3d{SWALL_SP_REMTREMBL}-prd:###ID###]',
    'EST'	    => 'http://www.ebi.ac.uk/cgi-bin/emblfetch?###ID###',
    'GENECARD'	    => 'http://bioinfo.weizmann.ac.il/cards-bin/cardsearch.pl?search=###ID###',
    'HSSP'	    => 'http://expasy.cbr.nrc.ca/cgi-bin/niceprot.pl?###ID###',
    'HUGO'	    => 'http://www.gene.ucl.ac.uk/cgi-bin/nomenclature/searchgenes.pl?field=symbol&anchor=equals&page_size=25&limit=1000&.cgifields=limit&.cgifields=page_size&match=###ID###',
    'INTERPRO'	    => 'http://www.ebi.ac.uk/interpro/IEntry?ac=###ID###',
    'LOCUSLINK'	    => 'http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=###ID###',
    'LOCUS'	    => 'http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=###ID###',
    'MIM'	    => 'http://www.ncbi.nlm.nih.gov/htbin-post/Omim/dispmim?###ID###',
    'OMIM'	    => 'http://www.ncbi.nlm.nih.gov/htbin-post/Omim/dispmim?###ID###', 
    'PDB'	    => 'http://pdb-browsers.ebi.ac.uk/pdb-bin/pdbids?id=###ID###',
    'PFAM'	    => 'http://www.sanger.ac.uk/srs6bin/cgi-bin/wgetz?[pfam-id:###ID###]+-e',
    'PRINTS'	    => 'http://methionine.sbc.man.ac.uk/cgi-bin/dbbrowser/sprint/searchprintss.cgi?display_opts=Prints&category=None&queryform=false&prints_accn=###ID###',
    'PROSITE'	    => 'http://www.expasy.ch/cgi-bin/nicesite.pl?###ID###',
    'REFSEQ'	    => 'http://www.ncbi.nlm.nih.gov/LocusLink/list.cgi?Q=###ID###',
    'RHDB'	    => 'http://www.sanger.ac.uk/srs6bin/cgi-bin/wgetz?-e+[RHDB-ID:###ID###]',
    'SHGC'	    => 'http://www-shgc.stanford.edu/cgi-bin/getSTSinfo?###ID###',
    'SNP'	    => 'http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?type=rs&rs=###ID###',
    #'SPTREMBL'	    => 'http://srs.ebi.ac.uk/srs6bin/cgi-bin/wgetz?-newId+-e+[SWALL-ACC:###ID###]',
    'SPTREMBL'	    => 'http://ca.expasy.org/cgi-bin/sprot-search-de?###ID###',
    'SWISSPROT'	    => 'http://ca.expasy.org/cgi-bin/sprot-search-de?###ID###',
    'SWISS-PROT'    => 'http://ca.expasy.org/cgi-bin/sprot-search-de?###ID###',
    'SP'	    => 'http://ca.expasy.org/cgi-bin/sprot-search-de?###ID###',
    'SWISS'	    => 'http://ca.expasy.org/cgi-bin/sprot-search-de?###ID###',
    #alt http://ca.expasy.org/cgi-bin/niceprot.pl
    #'SWISSPROT'    => 'http://www.ebi.ac.uk/cgi-bin/swissfetch?###ID###',
    #'SP'	    => 'http://www.ebi.ac.uk/cgi-bin/swissfetch?###ID###',
    #'SWISS'	    => 'http://www.ebi.ac.uk/cgi-bin/swissfetch?###ID###',
    'SWISSPROT_SANGER'=> 'http://www.sanger.ac.uk/srs6bin/cgi-bin/wgetz?-newId+-e+[SWISSPROT-ACC:###ID###]',
    'TRANSFAC'	    => 'http://transfac.gbf.de/cgi-bin/qt/getEntry.pl?###ID###',
    'TSC'	    => 'http://snp.cshl.org/db/snp/snp?name=###ID###',
    'WORM'	    => 'http://wormbase.sanger.ac.uk/perl/ace/elegans/misc/etree?name=WP%3A###ID###',
    'TRNA'	    => 'http://www.ebi.ac.uk/cgi-bin/emblfetch?###ID###',
    'TRACE'	    => 'http://trace.ensembl.org/perl/traceview?tracedb=0&traceid=###ID###',
    'TCORE'	    => '/perl/tcoreview?tcore=###ID###',
    'CPG'	    => 'http://www.ebi.ac.uk/cgi-bin/emblfetch?###ID###',
    'UNIGENE'	    => 'http://www.ncbi.nlm.nih.gov/UniGene/clust.cgi?ORG=###ID###',
    'EMBLGENE'	    => 'http://srs.ebi.ac.uk/srs6bin/cgi-bin/wgetz?-page+qResult+-e+[EMBL-Gene:###ID###]+-vn+1',

    'GRAMENE_HOME'  => '',  #gets Redirected if necessary to 'http://www.gramene.org',   #'http://brie2.cshl.org:8082',
    'DBEST_HOME'    => 'http://www.ncbi.nlm.nih.gov/',
    'DBSTS_HOME'    => 'http://www.ncbi.nlm.nih.gov/',
    'EMBL_HOME'	    => 'http://www.ebi.ac.uk/',
    'GDB_HOME'	    => 'http://gdbwww.gdb.org/',
    'GENETHON_HOME' => 'http://www.genethon.fr/',
    'RHDB_HOME'     => 'http://www.ebi.ac.uk/RHdb/',
    'RhALLOC_HOME'  => 'http://www.sanger.ac.uk/HGP/Rhmap/',
    'SANGER_STS_HOME'=> 'http://www.sanger.ac.uk/HGP/Rhmap/',
    'SHGC_HOME'     => 'http://www-shgc.stanford.edu',
    'TIGR_HOME'     => 'http://www.tigr.org/tdb/tdb.html',
    'WICGR_HOME'    => 'http://www-genome.wi.mit.edu/cgi-bin/contig/phys_map/',
    'WTCGR_HOME'    => 'http://www.well.ox.ac.uk/',
},
			    
#Convert Old to new ids
my %idfix = (
    'Exon' => 'GRME',
    'Transc' => 'GRMT',
    'Gene' => 'GRMG',
    'Transl' => 'GRMP',
);

sub idfix {
my ($id)=@_;
    $id =~ s/^(\D+)(\d+)$/($idfix{$1}||$1).sprintf("%011d",$2)/e if $id;
    return $id;
}

###############################################################################
######################### END OF LOCAL CONFIGURATION SECTION ##################
###############################################################################


####################
# Export by default
####################
@EXPORT     = qw(   $ENSEMBL_SERVERROOT
                    $ENSEMBL_PREFIX
                    $ENSEMBL_PREFIXE
                    $ENSEMBL_PREFIXT
                    $ENSEMBL_PREFIXG
                    $ENSEMBL_PREFIXP
		    $ENSEMBL_DRIVER
                    $ENSEMBL_HOST
                    $ENSEMBL_HOST_PORT
                    $ENSEMBL_DB
                    $ENSEMBL_MAP
                    $ENSEMBL_GMAP
                    $ENSEMBL_EMBL
                    $ENSEMBL_DISEASE
                    $ENSEMBL_EXPRESSION
		    $ENSEMBL_FAMILY
                    $ENSEMBL_TRACE_MOUSE
                    $ENSEMBL_MOUSE
                    $ENSEMBL_SNP
                    $ENSEMBL_HELP
                    $ENSEMBL_HELP_HOST
                    $ENSEMBL_HELP_PORT
                    $ENSEMBL_HELP_DBUSER
                    $ENSEMBL_HELP_DBPASS
                    $ENSEMBL_DBUSER
                    $ENSEMBL_DBPASS
                    $ENSEMBL_SEARCH
                    $ENSEMBL_SERVER
                    $ENSEMBL_ORACLE_HOME
                    $ENSEMBL_ORACLE_BASE
                    $ENSEMBL_ORACLE_SID
                    $ENSEMBL_TWO_TASK
                    $ENSEMBL_TNS_ADMIN
		    $ENSEMBL_GOLD
		    idfix
                );

############################
# Export anything asked for
############################
@EXPORT_OK  = qw (  $ENSEMBL_SERVERROOT
                    $ENSEMBL_PREFIX
                    $ENSEMBL_PREFIXE
                    $ENSEMBL_PREFIXT
                    $ENSEMBL_PREFIXG
                    $ENSEMBL_PREFIXP
		    $ENSEMBL_DRIVER
                    $ENSEMBL_HOST
                    $ENSEMBL_HOST_PORT
                    $ENSEMBL_DB
                    $ENSEMBL_MAP
                    $ENSEMBL_GMAP
                    $ENSEMBL_EMBL
                    $ENSEMBL_DISEASE
                    $ENSEMBL_EXPRESSION
		    $ENSEMBL_TRACE_MOUSE
                    $ENSEMBL_MOUSE
                    $ENSEMBL_SNP
                    $ENSEMBL_FAMILY
                    $ENSEMBL_HELP
                    $ENSEMBL_HELP_HOST
                    $ENSEMBL_HELP_PORT
                    $ENSEMBL_HELP_DBUSER
                    $ENSEMBL_HELP_DBPASS
                    $ENSEMBL_DBUSER
                    $ENSEMBL_DBPASS
                    $ENSEMBL_SEARCH
                    $ENSEMBL_SERVER
                    $ENSEMBL_ORACLE_HOME
                    $ENSEMBL_ORACLE_BASE
                    $ENSEMBL_ORACLE_SID
                    $ENSEMBL_TWO_TASK
                    $ENSEMBL_TNS_ADMIN
                    $ENSEMBL_PORT
                    $ENSEMBL_USER
                    $ENSEMBL_GROUP
                    $ENSEMBL_SERVERADMIN
                    $ENSEMBL_SERVERNAME
		    $ENSEMBL_GOLD
                    $ENSEMBL_MAIL_ERRORS
                    $ENSEMBL_ERRORS_TO
                    $ENSEMBL_EXTERNAL_DATABASES
                    $ENSEMBL_EXTERNAL_INDEXERS
		    $ENSEMBL_EXTERNAL_URLS
		    $EMBOSSBIN
		    idfix
);

###################################
# Export groups asked for by name
###################################
%EXPORT_TAGS    = (
    ALL =>  [qw(    $ENSEMBL_SERVERROOT
                    $ENSEMBL_PREFIX
                    $ENSEMBL_PREFIXE
                    $ENSEMBL_PREFIXT
                    $ENSEMBL_PREFIXG
                    $ENSEMBL_PREFIXP
		    $ENSEMBL_DRIVER
                    $ENSEMBL_HOST
                    $ENSEMBL_HOST_PORT
                    $ENSEMBL_DB
                    $ENSEMBL_MAP
                    $ENSEMBL_GMAP
                    $ENSEMBL_EMBL
                    $ENSEMBL_DISEASE
                    $ENSEMBL_EXPRESSION
		    $ENSEMBL_SNP
                    $ENSEMBL_TRACE_MOUSE
                    $ENSEMBL_MOUSE
                    $ENSEMBL_HELP
                    $ENSEMBL_HELP_HOST
                    $ENSEMBL_HELP_PORT
                    $ENSEMBL_HELP_DBUSER
                    $ENSEMBL_HELP_DBPASS
                    $ENSEMBL_DBUSER
                    $ENSEMBL_DBPASS
                    $ENSEMBL_SEARCH
                    $ENSEMBL_SERVER
                    $ENSEMBL_ORACLE_HOME
                    $ENSEMBL_ORACLE_BASE
                    $ENSEMBL_ORACLE_SID
                    $ENSEMBL_TWO_TASK
                    $ENSEMBL_TNS_ADMIN
                    $ENSEMBL_PORT
                    $ENSEMBL_USER
                    $ENSEMBL_GROUP
                    $ENSEMBL_SERVERADMIN
                    $ENSEMBL_SERVERNAME
		    $ENSEMBL_GOLD
                    $ENSEMBL_MAIL_ERRORS
                    $ENSEMBL_ERRORS_TO
                    $ENSEMBL_EXTERNAL_DATABASES
                    $ENSEMBL_EXTERNAL_INDEXERS
		    $EMBOSSBIN
                )],
    WEB =>  [qw(    $ENSEMBL_SERVERROOT
                    $ENSEMBL_PORT
                    $ENSEMBL_USER
                    $ENSEMBL_GROUP
                    $ENSEMBL_SERVERADMIN
                    $ENSEMBL_SERVERNAME
                    $ENSEMBL_SERVER
                    $ENSEMBL_ORACLE_HOME
                    $ENSEMBL_ORACLE_BASE
                    $ENSEMBL_ORACLE_SID
                    $ENSEMBL_TWO_TASK
                    $ENSEMBL_TNS_ADMIN
                    $ENSEMBL_MAIL_ERRORS
                    $ENSEMBL_ERRORS_TO
		    $EMBOSSBIN
		    idfix
                )],
    INDEX => [qw(   $ENSEMBL_EXTERNAL_DATABASES
                    $ENSEMBL_EXTERNAL_INDEXERS
                )],
    URL =>  [qw(   $ENSEMBL_EXTERNAL_URLS
                )],

);

1;
