#!/usr/local/bin/perl
$LOGPATH    = '/usr/local/apache/logs';
$PIDFILE    = 'httpd.pid';
$MAXCYCLE   = 9;
$GZIP       = '/bin/gzip';

@LOGNAMES=('access_log','error_log');
%ARCHIVE=('access_log'=>1,'error_log'=>1);

chdir $LOGPATH;  # Change to the log directory
foreach $filename (@LOGNAMES) {
    system "$GZIP -c $filename.$MAXCYCLE >> $filename.gz" 
        if -e "$filename.$MAXCYCLE" and $ARCHIVE{$filename};
    for (my $s=$MAXCYCLE; $s--; $s >= 0 ) {
        $oldname = $s ? "$filename.$s" : $filename;
        $newname = join(".",$filename,$s+1);
        rename $oldname,$newname if -e $oldname;
    }
}
kill 'HUP',`cat $PIDFILE`;

