# -*- Mode: perl -*-
# file: GrameneSubs.pm

package GrameneSubs;

use strict;
use lib '..';
use CGI qw(:standard *table *Tr *td);
use Ace::Browser::AceSubs qw/:DEFAULT TypeSelector AceHeader Configuration Url ResolveUrl/;
use GramenePage;
use vars qw/@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS/;

require Exporter;
@ISA = 'Exporter';

@EXPORT = qw(
	     PrintTop PrintBottom PrintWarning PrintPrompt PrintObj
	     PrintOne PrintMultiple DataRow
	    );
@EXPORT_OK = qw(Search_Swish Display_Swish_Hits AceSearchMenuBar);

%EXPORT_TAGS = (swish => [qw(Search_Swish Display_Swish_Hits)]
	       );

my $page;

# boilerplate for the top of the page
sub PrintTop {
  my ($object,$class,$title,@additional_header_stuff) = @_;
  $class ||= $object->class if defined $object && ref($object);
  AceHeader();
  $page = GramenePage->new(Apache->request) || AceError("Can't open Gramene page configurator");
  $title ||= defined($object) ? "$class Report for: $object" : $class ? "$class Report" : '';
  print start_html (
		    '-Title'   => $title,
		    '-Style'   => {-src => $page->stylesheet},
		    @additional_header_stuff,
		    );
  print $page->start_body;
  print TypeSelector($object,$class,1) if defined $object;
  print hr, br, h2({-class=>'heading'},$title) if $title;
}

# boilerplate for the bottom of the page
sub PrintBottom {
  print $page->end_body;
}

sub PrintWarning {
  my ($name,$class) = @_;
  print p(font({-color => 'red'},
	       "The $class named \"$name\" is not found in the database."));
}

sub PrintPrompt {

  my ($class, $example) = @_;
  print
    start_form,
    p({-class=>'caption'},"Type in a ".$class." symbol, such as ",
      cite($example),':'),
    p("Symbol: ",
      textfield(-name=>'name')),
    end_form;
}

sub PrintObj {

  my $obj = shift;

  print TR(
	   th({-class=>'datatitle'},'Object Class'),
	   td({-class=>'databody'},$obj->class)
	   );
  print TR(
	   th({-class=>'datatitle'},'Object Name'),
	   td({-class=>'databody'},$obj->name)
	   );
}


sub PrintOne {
  my $label = shift;
  my $obj   = shift;
  return unless $obj;
  print TR(
	   th({-class=>'datatitle'},$label),
	   td({-class=>'databody'},$obj->isClass && $obj->class !~ /Text/ ? ObjectLink($obj) : $obj)
	  );
}
sub PrintMultiple {
  my $label = shift;
  my @a = @_;
  return unless @a;
  my $first = shift @a;
  print TR(
	   th({-class=>'datatitle'},$label),
	   td({-class=>'databody'},$first->isClass && $first->class !~ /Text/ ? ObjectLink($first) : $first)
	  );
  for my $obj (@a) {
    print TR(
	     th({-class=>'datatitle'},'&nbsp;'),
	     td({-class=>'databody'},$obj->isClass && $obj->class !~ /Text/ ? ObjectLink($obj) : $obj)
	    );
  }
}

# a line of the "summary table"
sub DataRow {
  my $title = shift;
  my @r = @_;
  if (@r) {
    my $first = shift @r;
    print TR(
	   th({-class=>'datatitle'},$title),
	   td({-class=>'databody'},$first->isObject ? ObjectLink($first) : $first)
	   );
    foreach (@r) {
      print TR(
	       th({-class=>'datatitle'},'&nbsp;'),
	       td({-class=>'databody'},$_->isObject ? ObjectLink($_) : $_)
	      );
    }
  } else {
      print TR(
	   th({-class=>'datatitle'},$title),
	   td({-class=>'databody'},'Not Available')
	   );
  }
}

sub Search_Swish {
  my $pattern = quotemeta shift;

  my $swish = Configuration->Swishe;
  my $index = Configuration->Swishindex;
  my $strip = Configuration->Swishstrip;
  my %hits;
  open (SWISH,"$swish -v0 -w $pattern -f $index |") or return;
  while (<SWISH>) {
    chomp;
    my ($relevance,$path,$url,$title,$size) = m!^(\d+) ($strip/?(/.+)) "([^\"]+)" (\d+)!o or next;
    $hits{$path} = {relevance=>$relevance,url=>$url,title=>$title,size=>$size};
  }
  close SWISH;
  return unless %hits;  # return undef if no hits
  return \%hits;        # return hits, indexed by relevance
}

sub Display_Swish_Hits {
  my $hits = shift;
  my $highlight = shift;
  my $count = $hits  ? keys %$hits : 0;
  my $title = $count ? p(strong($count)," matches in Rice Genetic Newsletter &amp; Documentation")
    : p({-class=>'error'},'No matches in Rice Genetics Newsletter or Docs');

    print
      a({-name=>'static_results'},''),
	start_table({-border=>0,-cellspacing=>2,-cellpadding=>2,
		     -width=>'100%',-align=>'CENTER',-class=>'resultsbody'}),
		       TR(th({-class=>'resultstitle',-colspan=>2},$title));
  unless ($count) {
    print end_table,p();
    return;
  }

  print TR(th('Score'),th('Document'));
  for my $path (sort {$hits->{$b}{relevance} <=> $hits->{$a}{relevance}} keys %$hits) {
    my $abstract = get_swish_abstract($path,$highlight);
    #(my $url=$hits->{$path}{url}) =~ s,/newsletters/ricegenomenewslet/,http://rgp.dna.affrc.go.jp/rgp/ricegenomenewslet/, ;
    print TR({-valign=>'TOP'},
	     td($hits->{$path}{relevance}),
	     td(
		p(a({-href=>$hits->{$path}{url}},$hits->{$path}{title})),
		p($abstract)
	       ));
  }
  print end_table;

}

sub get_swish_abstract {
  my $path  = shift;
  my $terms = shift;

  # turn hilight into regex
  # extract phrases first
  my @terms = $terms =~ /"([^\"]+)"/g; #capture 'em
  $terms =~ s/"([^\"]+)"//;            #get rid of 'em
  push @terms,split /\s+/,$terms;      #rest split by whitespace
  @terms = map {quotemeta $_} @terms;  #get rid of metachars
  my $regex = join '|',@terms;         #whole thing becomes a regex

  my $abstract;
  open (F,$path) or return;
  local $/ = ""; # paragraph mode
  while (<F>) {
    chomp;
    s/<[^>]+>//g;  #fast but flawed way of eliminating HTML
    next unless /\b(.{0,50})($regex)(.{0,50})\b/;
    $abstract .= "$1<em>$2</em>$3...";
  }
  close F;
  $abstract;
}



sub AceSearchMenuBar {
  my $quovadis = url(-absolute=>1,-path=>1);
  my $config = Configuration();
  my @searches = $config->searches;
  return unless @searches;

  my @cells;
  my ($url,$home) = @{$config->Home} if $config->Home;

  if (my $bookmark = cookie('HOME_'.$config->Name)) {
    $bookmark=~s/ /+/g;  # some bug
    push(@cells,a({-href=>$bookmark,-target=>'_top'},$home));
  } else {
    push(@cells,a({-href=>$url,-target=>'_top'},$home)) if $home;
  }

  my $self = url(-relative=>1);
  foreach my $page (@searches) {
    my ($name,$url,$on,$off,$size) = @{$config->searches($page)}{qw/name url onimage
								   offimage size/};
    my $active = $url =~ /\b$self\b/;
    my $image = $active ? $on : $off;

    push @cells,($active)
        ? strong(font({-color=>'red'},$name))
	: a({-href=>ResolveUrl($url),-target=>'_top'},$name);
  }
  return 
    table({-border=>0,-bgcolor=>"#eeeeff",-width=>'100%',-class=>'search',-cellpadding=>0, -cellspacing=>0},	#, -height=>20 is deprecated & looks ok without
	  TR({-class=>'search',-align=>'CENTER'},td({-class=>'search'},\@cells)));
}


=item AceNotFound([$class,$name],[$printed_Top_already])

This subroutine will print out an error message indicating that the
requested object is not present in AceDB, even as a name. It will then
exit the script. If the class and name of the object are not provided
as arguments, they are taken from CGI's param() function.

=cut

sub AceNotFound {
  my $class = shift || param('class');
  my $name  = shift || param('name');
  my $notop = shift;
  PrintTop(undef,undef,"$class: $name not found") unless $notop;
  print p(font({-color => 'red'},
	       strong("The $class named \"$name\" is not found in the database.")));
  PrintBottom();
  Apache->exit(0) if defined &Apache::exit;
  exit(0);
}

1;
