package GramenePage;
# this creates the page "wrapper" around both dynamic and static gramene pages

use strict;
use Apache;
use Apache::File;
use constant CELL_LINEPADDING   => 0;	# was 2
use constant CELL_LINESPACING   => 0;
use constant DEFAULT_PAGEWIDTH   => 500;
use constant DEFAULT_PANELWIDTH  => 100;
my %PANELS;

sub new {
  my $class = shift;
  my $r     = shift;

  my $conf        = $r->dir_config('NavConf') or return;
  my $conf_file   = $r->server_root_relative($conf);
  -e $conf_file or print STDERR "no $conf_file\n" and return;

  my $nav_panel   = $class->read_configuration($conf_file) or return;

  (my $current_url= $r->uri) =~ s,^//*,/,;

  $r->err_header_out('ensembl_headers_out'=>1);
  
  return bless {
		panel      => $nav_panel,
		current_url=> $current_url,
		current_args=> scalar($r->args),
		stylesheet => $r->dir_config('Stylesheet'),
		background => $r->dir_config('Background'),
		bgcolor    => $r->dir_config('Bgcolor'),
		logo       => $r->dir_config('Logo'),
		enslogo    => $r->dir_config('EnsLogo'),
		banner     => $r->dir_config('Banner'),
		pagewidth  => $r->dir_config('PageWidth')   || DEFAULT_PAGEWIDTH,
		panelwidth => $r->dir_config('PanelWidth')  || DEFAULT_PANELWIDTH,
		footer     => $r->dir_config('Footer'),
	       },$class;
}

# read the navigation bar configuration file and return it as a
# hash.
sub read_configuration {
  my $class = shift;
  my $conf  = shift;
  my $mod_time = (stat $conf)[9];

  return $PANELS{$conf} if $PANELS{$conf}
    && $PANELS{$conf}->modified >= $mod_time;

  return $PANELS{$conf} = GrameneNavBar->new($conf);
}

sub panel       { shift->{panel}         }
sub banner      { shift->{banner}        }
sub logo        { shift->{logo}          }
sub enslogo     { shift->{enslogo}       }
sub background  { shift->{background}    }
sub bgcolor     { shift->{bgcolor}       }
sub stylesheet  { shift->{stylesheet}    }
sub pagewidth   { shift->{pagewidth}     }
sub panelwidth  { shift->{panelwidth}    }
sub footer      { shift->{footer}        }
sub current_url { shift->{current_url}   }
sub current_args { shift->{current_args}   }
sub modified    { shift->panel->modified }
sub stylesheet_link  {
  my $self     = shift;
  my $css_url  = $self->{stylesheet};
  return qq(<link rel="stylesheet" href="$css_url" type="text/css">\n);
}

# this starts the table that includes the navigation panel and background
sub start_body {
  my $self = shift;
  my %attr=@_;  # { -ensembl=> .., -bodyattr=>'..', -bodyfirst=>'...' }
  my $background = $self->background;
  my $bgcolor    = $self->bgcolor;
  my $pagewidth  = $self->pagewidth;
  my $panelwidth = $self->panelwidth;

  my $text;
  my $ensembl = $attr{-ensembl} || 0;
  my $bodyattr= $attr{-bodyattr} || '' ;
  my $bodyfirst= $attr{-bodyfirst} || '' ;
  $bodyattr .= qq( background="$background") if $background;
  $bodyattr .= qq( bgcolor="$bgcolor") if $bgcolor;

  my $maintext= $ENV{'DevelopmentSite'} ? 
	qq(<br><h2>This is the Gramene Development Site.  For the Live Site go <a href="http://www.gramene.org).$self->current_url.($self->current_args? '?'.$self->current_args : '').
	qq(">here</a></h2>)
	      : '';


  $text = $bodyattr ? qq(<body $bodyattr>\n)
		       : qq(<body>\n);
  $text .= $bodyfirst;


      $text .= $maintext;

      $text .=  qq(<table border="0" cellpadding="0" cellspacing="2" width="100%">\n);
      $text .=  qq(<tr><td class="navbar" width="1%" valign="TOP">\n);
      $text .=  $self->make_panel($ensembl);
      $text .=  qq(</td><td valign="TOP">\n);
      #$text .=  qq(</td><td width="$pagewidth" valign="TOP">\n);
      $text .= qq(<a name="top"></a>);
  return $text;
}

sub end_body {
  my $self = shift;
  my $additional_stuff = shift ||'';
  my $part=shift || 0;	# so we can put something after the navbar
  my $text = $part==2 ? '' : <<END_OF_TEXT;
</td></tr>
</table>
END_OF_TEXT
  return $text if $part==1;
  if (my $f = $self->footer) {
    if (my $fh = Apache::File->new($f)) {
      $text .= $_ while <$fh>;
    }
  }
  $text .= "$additional_stuff</body></html>\n";
  return $text;
}

sub make_panel {
  my $self         = shift;
  my $ensembl = shift;
  my $current_url  = $self->current_url;
  my $panel        = $self->panel;

  # create the navigation panel;
  my $cp   = CELL_LINEPADDING;
  my $cs   = CELL_LINESPACING;
  my $banner     = $self->banner;
  my $logo       = $self->logo;


  my $guide=qq(<table border="0" cellpadding="$cp" cellspacing="$cs">\n);
  my $banner_img = $banner ? qq(<img src="$banner"   alt="[Home Page]" border="0">)
                           : '<h1>Gramene</h1>';
  my $logo_img   = $logo   ? qq(<img src="$logo"     alt="[Home Page]" border="0">)
                           : '&nbsp';

  $guide .= qq(<tr><td class="banner"><a href="/">$banner_img</a></td></tr>
      <tr><td class="logo" width="1%"><a href="/">$logo_img</a></td></tr>\n);

#  $guide .= qq(<tr><th>&nbsp;</th></tr>\n);
  #the first element of this array will be the longest panel url which is a subsequence of the current url
  my @above_current= sort { length($b)<=>length($a) } grep { $current_url =~ /^$_/ } $panel->urls; 
  #print STDERR "ac=",join("+",@above_current),"\n";
  @above_current=("0") unless @above_current;
  foreach my $url ($panel->urls) {
    my $label = $panel->label($url);
    my $cell;
    $label =~ s/^(\.*)//;
    my $prefix='&nbsp;' x length($1) ;
    $label= $label =~ /^"/ ? substr($label,1) : CGI->escapeHTML($label);
    if($url !~ /\D/) {  #all digits => not a url
	$cell=qq(<tr><td nowrap class="notcurrent">$prefix$label&nbsp;</td></tr>);
	#$cell=qq(<tr><td nowrap class="notcurrent">$prefix<a class="notcurrent">$label</a></td></tr>);
    } else {
	my $under_current = $url eq $above_current[0];	#$current_url =~ /^$url/;
	my $is_current = $current_url eq $url;
	$cell = $under_current ?
		    $is_current ?
          qq(<tr><td nowrap class="currentpage">$prefix$label&nbsp;</td></tr>)
		    :
          qq(<tr><td nowrap class="currentpage">$prefix<a class="currentpage" href="$url">$label</a>&nbsp;</td></tr>)
	    :
	  qq(<tr><td nowrap class="notcurrent">$prefix<a class="notcurrent" href="$url">$label</a>&nbsp;</td></tr>);
    }
    $guide .= $cell."\n";
  }
  $guide .= qq(<tr><td><br>
	<form METHOD=GET ACTION="/gramene/searches/browser">
	<a name="search"><b><font>Search:&nbsp;</font></b></a>  
	<center>
	<input TYPE="text" NAME="query"> &nbsp; 
	<input class="grain" TYPE="submit" value="Search">
	<input TYPE="hidden" value="Long">
	<input TYPE="hidden" name="class" value="Any">
	<input TYPE="hidden"   name="RGN" value="on">
	</center>
	</form>  
	</td></tr>);
  if($ensembl) {
      my $enslogo       = $self->enslogo;
      my $enslogo_img = $enslogo ? qq(<IMG SRC="$enslogo" BORDER="0" alt="Ensembl">)
      			         : h2('Ensembl');
      $guide .= qq(<tr><th>&nbsp;</th></tr>\n);
      
      $guide .=  qq(<tr><td class="banner"><A HREF="http://www.ensembl.org">$enslogo_img</A></td></tr>\n);

  }
  $guide .= "</table>\n";
  return $guide;
}

###################### package GrameneNavBar ##############################

package GrameneNavBar;
# create a new GrameneNavBar object
sub new {
    my ($class,$conf_file) = @_;
    my (@c,%c);
    my $fh = Apache::File->new($conf_file) || return;
    while (<$fh>) {
	chomp;
	s/^\s+//; s/\s+$//;   #fold leading and trailing whitespace
	next if /^#/ || /^$/; # skip comments and empty lines
	next unless my($url, $label) = /^(\S+)\s+(.+)/;
	#$label =~ s/^(\.+)/'&nbsp;' x length($1)/e;  do this later so not part of <a>
	push @c, $url;     # keep the url in an ordered array
	$c{$url} = $label; # keep its label in a hash
    }
    return bless {'urls' => \@c,
		  'labels' => \%c,
		  'modified' => (stat $conf_file)[9]}, $class;
}

# return ordered list of all the URLs in the navigation bar
sub urls  { return @{shift->{'urls'}}; }

# return the label for a particular URL in the navigation bar
sub label { return $_[0]->{'labels'}->{$_[1]} || $_[1]; }

# return the modification date of the configuration file
sub modified { return $_[0]->{'modified'}; }

1;
