package CSHL::DB;

#-----------------------------------------------------
# $Id: DB.pm,v 1.4 2001/12/28 16:51:36 steven Exp $
#
# File       : DB.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2000/08/31
# Purpose    : generic CSHL database interface
# 
# Copyright (C) 2000 logsoft.com
#-----------------------------------------------------

=head1 NAME

DB.pm - Generic CSHL database interface

=head1 SYNOPSIS

  use CSHL::DB;
  my $dbh = CSHL::DB->new({ DB_NAME => 'FOO' }) or die; 

B<or>

  my %options = ( 
      # only req'd arg
      DB_NAME   => 'FOO',           
  
      # default is 'mysql'
      DB_DRIVER => 'sybase'         
  
      # default is 'db1'
      HOST      => 'chinatown',     
  
      # default is 'bgep'
      USER      => 'user',          
  
      # default is 'g0dz1ll2'
      PASS      => 'password',      
  
      # default is { RaiseError => 1}, 
      # best to always connect with RaiseError!
      OPTS      => { RaiseError => 0}, 
  );
  my $dbh = CSHL::DB->new(\%options) or die;

=head1 DESCRIPTION

This module is meant to be a generic interface for connecting to 
CSHL databases.  The only required argument is DB_NAME.  All other
arguments have a default value, as shown above.  Calling "new" with 
"OPTS => { RaiseError => 1 }" (the default value) will cause all bad
database calls (including connect) to automatically die() with the 
DBI::errstr;  therefore, just saying "or die" will re-raise the error.

=cut

use strict;
use DBI;
use DBD::Oracle;
use CSHL::Config;
use vars qw( @ISA );
use constant DEFAULT_DRIVER => 'oracle';
use constant DEFAULT_HOST   => 'raclette';
use constant DEFAULT_USER   => 'cmap';
use constant DEFAULT_PASS   => 'grain';
use constant DEFAULT_PORT   => '1521';
use constant DEFAULT_SID    => 'gramene';
use constant DEFAULT_OPTS   => {
    RaiseError       => 1,
    FetchHashKeyName => 'NAME_lc',
    LongReadLen      => 3000,
    LongTruncOk      => 1,
};

BEGIN { @ISA = qw[ DBI::db DBI ]; }

sub new {
    my ($class, $options) = @_;
    my $db_name = $options->{'DB_NAME'} or die 'No database name';
    my $driver  = $options->{'DRIVER'}  || DEFAULT_DRIVER;
    my $host    = $options->{'HOST'}    || DEFAULT_HOST;
    my $user    = $options->{'USER'}    || DEFAULT_USER;
    my $pass    = $options->{'PASS'}    || DEFAULT_PASS;
    my $port    = $options->{'PORT'}    || DEFAULT_PORT;
    my $opts    = $options->{'OPTS'}    || DEFAULT_OPTS;
    my $sid     = $options->{'SID'}     || DEFAULT_SID;
#    my $dsn     = join(':', 'DBI', $driver, $db_name, 'host='.$host);
#    my $db      = DBI->connect($dsn, $user, $pass, $opts);

#    my $db = DBI->connect('dbi:Oracle:', qq{$user/$pass@(DESCRIPTION=
#    (ADDRESS=(PROTOCOL=TCP)(HOST=$host)(PORT=$port))
#    (CONNECT_DATA=(SID=$sid)))}, "", $opts);
 
    my $db = DBI->connect( MapDataSource, MapDBUser, MapDBPassword, $opts );

    return undef unless defined $db;
    return bless $db, $class;
}

=head2 DESTROY

When the database handle is destroyed, it will automatically call the
DBI disconnect() method, thereby allowing the programmer to be even
lazier than he or she otherwise might have been.

=cut

sub DESTROY {
    my $self = shift;
    $self->disconnect;
    $self->SUPER::DESTROY;
}

1;
__END__

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1), DBI.

=cut

#-----------------------------------------------------
# Rescue the drowning and tie your shoestrings.
# Henry David Thoreau 
#-----------------------------------------------------
