package CSHL::Constants;

#-----------------------------------------------------
# $Id: Constants.pm,v 1.3 2001/12/10 20:07:13 steven Exp $
#
# File       : Constants.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/08/08
# Purpose    : constants modules
#-----------------------------------------------------

=head1 NAME

Constants.pm - constants modules

=head1 SYNOPSIS

  use Constants.pm;
  blah blah blah

=head1 DESCRIPTION

Blah blah blah.

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1).

=cut

use strict;
use GD;
use Apache::Reload;
use base qw( Exporter );
use vars qw( @EXPORT  );
require Exporter;

@EXPORT = qw[ 
    ARC
    CHR_SQL
    CENTIMORGANS
    COLORS
    DB_NAME
    DEFAULT
    HL_COLORS
    LINE
    FILLED_RECT
    MARKER
    MAP_URI
    MIN_CONTIG_CM_LENGTH
    MIN_SQL
    MIN_MAP_LENGTH
    MAP_STUDY_SQL
    MAX_CM_DISTANCE_DISCORDANT
    MAX_SQL
    MAX_PIXELS_FROM_TICK
    OFFSET
    PHYS_MAP_STUDY_SQL
    PIXELS_TO_CENTIMORGANS
    RECTANGLE
    SCALES
    SOAP_URI
    SOAP_PROXY
    SPECIES_SQL
    STRING
    STRING_UP
    TEMPLATE_DIR
    URIS
    ZOOM_URI
];

use constant ARC => 'arc';

use constant CHR_SQL     => qq[
    select   map_id, linkage_group 
    from     map 
    where    map_study_id=?
    order by linkage_group
];

#
# Used to determine map_coord_type (either 'marker' or 'cM')
#
use constant CENTIMORGANS => 'cM';

use constant COLORS => {
    white        => ['FF','FF','FF'],
    black        => ['00','00','00'],
    aliceblue    => ['F0','F8','FF'],
    antiquewhite => ['FA','EB','D7'],
    aqua         => ['00','FF','FF'],
    aquamarine   => ['7F','FF','D4'],
    azure        => ['F0','FF','FF'],
    beige        => ['F5','F5','DC'],
    bisque       => ['FF','E4','C4'],
    blanchedalmond=> ['FF','EB','CD'],
    blue         => ['00','00','FF'],
    blueviolet   => ['8A','2B','E2'],
    brown        => ['A5','2A','2A'],
    burlywood    => ['DE','B8','87'],
    cadetblue    => ['5F','9E','A0'],
    chartreuse   => ['7F','FF','00'],
    chocolate    => ['D2','69','1E'],
    coral        => ['FF','7F','50'],
    cornflowerblue=> ['64','95','ED'],
    cornsilk     => ['FF','F8','DC'],
    crimson      => ['DC','14','3C'],
    cyan         => ['00','FF','FF'],
    darkblue     => ['00','00','8B'],
    darkcyan     => ['00','8B','8B'],
    darkgoldenrod=> ['B8','86','0B'],
    darkgray     => ['A9','A9','A9'],
    darkgreen    => ['00','64','00'],
    darkkhaki    => ['BD','B7','6B'],
    darkmagenta  => ['8B','00','8B'],
    darkolivegreen=> ['55','6B','2F'],
    darkorange    => ['FF','8C','00'],
    darkorchid    => ['99','32','CC'],
    darkred       => ['8B','00','00'],
    darksalmon    => ['E9','96','7A'],
    darkseagreen  => ['8F','BC','8F'],
    darkslateblue => ['48','3D','8B'],
    darkslategray => ['2F','4F','4F'],
    darkturquoise => ['00','CE','D1'],
    darkviolet    => ['94','00','D3'],
    deeppink      => ['FF','14','100'],
    deepskyblue   => ['00','BF','FF'],
    dimgray       => ['69','69','69'],
    dodgerblue    => ['1E','90','FF'],
    firebrick     => ['B2','22','22'],
    floralwhite   => ['FF','FA','F0'],
    forestgreen   => ['22','8B','22'],
    fuchsia       => ['FF','00','FF'],
    gainsboro     => ['DC','DC','DC'],
    ghostwhite    => ['F8','F8','FF'],
    gold          => ['FF','D7','00'],
    goldenrod     => ['DA','A5','20'],
    gray          => ['80','80','80'],
    green         => ['00','80','00'],
    greenyellow   => ['AD','FF','2F'],
    honeydew      => ['F0','FF','F0'],
    hotpink       => ['FF','69','B4'],
    indianred     => ['CD','5C','5C'],
    indigo        => ['4B','00','82'],
    ivory         => ['FF','FF','F0'],
    khaki         => ['F0','E6','8C'],
    lavender      => ['E6','E6','FA'],
    lavenderblush => ['FF','F0','F5'],
    lawngreen     => ['7C','FC','00'],
    lemonchiffon  => ['FF','FA','CD'],
    lightblue     => ['AD','D8','E6'],
    lightcoral    => ['F0','80','80'],
    lightcyan     => ['E0','FF','FF'],
    lightgoldenrodyellow=> ['FA','FA','D2'],
    lightgreen    => ['90','EE','90'],
    lightgrey     => ['D3','D3','D3'],
    lightpink     => ['FF','B6','C1'],
    lightsalmon   => ['FF','A0','7A'],
    lightseagreen => ['20','B2','AA'],
    lightskyblue  => ['87','CE','FA'],
    lightslategray=> ['77','88','99'],
    lightsteelblue=> ['B0','C4','DE'],
    lightyellow   => ['FF','FF','E0'],
    lime          => ['00','FF','00'],
    limegreen     => ['32','CD','32'],
    linen         => ['FA','F0','E6'],
    magenta       => ['FF','00','FF'],
    maroon        => ['80','00','00'],
    mediumaquamarine=> ['66','CD','AA'],
    mediumblue    => ['00','00','CD'],
    mediumorchid  => ['BA','55','D3'],
    mediumpurple  => ['100','70','DB'],
    mediumseagreen=> ['3C','B3','71'],
    mediumslateblue=> ['7B','68','EE'],
    mediumspringgreen=> ['00','FA','9A'],
    mediumturquoise=> ['48','D1','CC'],
    mediumvioletred=> ['C7','15','85'],
    midnightblue  => ['19','19','70'],
    mintcream     => ['F5','FF','FA'],
    mistyrose     => ['FF','E4','E1'],
    moccasin      => ['FF','E4','B5'],
    navajowhite   => ['FF','DE','AD'],
    navy          => ['00','00','80'],
    oldlace       => ['FD','F5','E6'],
    olive         => ['80','80','00'],
    olivedrab     => ['6B','8E','23'],
    orange        => ['FF','A5','00'],
    orangered     => ['FF','45','00'],
    orchid        => ['DA','70','D6'],
    palegoldenrod => ['EE','E8','AA'],
    palegreen     => ['98','FB','98'],
    paleturquoise => ['AF','EE','EE'],
    palevioletred => ['DB','70','100'],
    papayawhip    => ['FF','EF','D5'],
    peachpuff     => ['FF','DA','B9'],
    peru          => ['CD','85','3F'],
    pink          => ['FF','C0','CB'],
    plum          => ['DD','A0','DD'],
    powderblue    => ['B0','E0','E6'],
    purple        => ['80','00','80'],
    red           => ['FF','00','00'],
    rosybrown     => ['BC','8F','8F'],
    royalblue     => ['41','69','E1'],
    saddlebrown   => ['8B','45','13'],
    salmon        => ['FA','80','72'],
    sandybrown    => ['F4','A4','60'],
    seagreen      => ['2E','8B','57'],
    seashell      => ['FF','F5','EE'],
    sienna        => ['A0','52','2D'],
    silver        => ['C0','C0','C0'],
    skyblue       => ['87','CE','EB'],
    slateblue     => ['6A','5A','CD'],
    slategray     => ['70','80','90'],
    snow          => ['FF','FA','FA'],
    springgreen   => ['00','FF','7F'],
    steelblue     => ['46','82','B4'],
    tan           => ['D2','B4','8C'],
    teal          => ['00','80','80'],
    thistle       => ['D8','BF','D8'],
    tomato        => ['FF','63','47'],
    turquoise     => ['40','E0','D0'],
    violet        => ['EE','82','EE'],
    wheat         => ['F5','DE','B3'],
    whitesmoke    => ['F5','F5','F5'],
    yellow        => ['FF','FF','00'],
    yellowgreen   => ['9A','CD','32'],
};

use constant DB_NAME => 'MAPS';

use constant DEFAULT  => {
    data_label_offset => 50,
    highlight_color   => 'yellow',
    image_type        => 'png',
    label_font        => gdMediumBoldFont,
    scale             => 1,
    scroll_interval   => 10, # how many cM to move on the map
    tick_font         => gdTinyFont,
    tick_width        => 5,
    width             => 500,
};

use constant HL_COLORS => [ qw(
    aqua
    orange
    palegreen
    violet
    hotpink
    lightsteelblue
) ];

use constant LINE => 'line';

use constant FILLED_RECT => 'filledRectangle';

use constant MAP_STUDY_SQL => qq[
    select   ms.map_study_id, ms.map_study_name
    from     map_study ms, map_type mt
    where    mt.map_type='Genetic'
    and      ms.species_id=?
    and      ms.map_type_id=mt.map_type_id
    order by map_study_name
];

use constant PHYS_MAP_STUDY_SQL => qq[
    select   ms.map_study_id, ms.map_study_name,
             mt.map_type
    from     map_study ms, map_type mt
    where    ms.map_type_id=mt.map_type_id
    and      ms.species_id=?
    order by map_study_name
];

use constant PIXELS_TO_CENTIMORGANS => 20;

#
# Used to determine map_coord_type (either 'marker' or 'cM')
#
use constant MARKER => 'marker';

use constant MAX_CM_DISTANCE_DISCORDANT => 10;

use constant MAX_SQL     => qq[
    select   max(mp.position_start)
    from     map_position mp, map
    where    mp.map_id=map.map_id
    and      map.map_study_id=?
    and      map.map_id=?
];

use constant MAX_PIXELS_FROM_TICK => 25;

use constant MIN_CONTIG_CM_LENGTH => 1;

use constant MIN_SQL      => q[
    select   min(mp.position_start)
    from     marker mrk, map_position mp, map
    where    mrk.marker_id = mp.marker_id
    and      mp.map_id = map.map_id
    and      map.map_study_id=?
    and      map.map_id=?
];

use constant MIN_MAP_LENGTH => 40;

use constant MAP_URI      => '/map';

use constant OFFSET => 10;

use constant RECTANGLE => 'rectangle';

use constant SCALES => [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ];

use constant SOAP_URI   => 
    #'http://oakhill:8080/CSHL/SOAP/ComparativeMapData';
    'http://brie2.cshl.org:8082/CSHL/SOAP/ComparativeMapData';

use constant SOAP_PROXY => 
    #'http://oakhill:8080/soap';
    'http://brie2.cshl.org:8082/soap';

use constant SPECIES_SQL => q[
    select   species_id, full_name, common_name
    from     species
    order by common_name
];

use constant STRING => 'string';

use constant STRING_UP => 'stringUp';

use constant TEMPLATE_DIR => '/usr/local/apache/templates/comparative_maps';

use constant BASE_URI => '/maps';

use constant URIS => {
    map_viewer    => BASE_URI.'/viewer',
    contig_viewer => BASE_URI.'/contig',
#    marker_viewer => BASE_URI.'/marker',
    marker_viewer => 'http://www.gramene.org/gramene/map/marker',
};

use constant ZOOM_URI => '/info';

1;

#-----------------------------------------------------
# Excess of sorrow laughs. Excess of joy weeps.
# William Blake
#-----------------------------------------------------
