package CSHL::Config; 

use strict;

use base qw( Exporter );
use vars qw( @EXPORT  );
require Exporter;

@EXPORT = qw[ 
    OtherGrameneServerName
    OtherGrameneServerIP
    EnsemblServerName
    EnsemblLocator 
    GMAPLocator 
    SequenceDataSource
    SequenceDBUser
    SequenceDBPassword
    CuratorDataSource
    CuratorDBUser
    CuratorDBPassword
    CuratorDBOptions	     
    OntologyDataSource
    OntologyDBUser
    OntologyDBPassword
    OntologyDBOptions
    MutantDataSource
    MutantDBUser
    MutantDBPassword
    MutantDBOptions	     
    MapDataSource
    MapDBUser
    MapDBPassword 
    MapDBOptions 
    OldEnsemblLocator 
    OldSequenceDataSource
    OldSequenceDBUser
    OldSequenceDBPassword 
    OldOntologyDataSource
    OldOntologyDBUser
    OldOntologyDBPassword 
    OldMapDataSource
    OldMapDBUser
    OldMapDBPassword 
    OldMapDBOptions 
    RemoteBlastScript
    SequenceName
    SequencePass
    MapName
    MapPass
    OntologyName
    OntologyPass
    CuratorName
    CuratorPass
    MutantName
    MutantPass    
];
#Location of the script to execute blast
use constant   RemoteBlastScript => 'ServerB.cshl.org/perl/blast/remote_blast.pl';

# these variables are for Apache::Mail.pm - to recognize requests from 
# the other server (main vs. development) and to make them

use constant   OtherGrameneServerName => 'ServerD.cshl.org';
use constant   OtherGrameneServerIP => 'xxx.xxx.xxx.xxx';

use constant   EnsemblServerName => 'ServerE.cshl.org';

########################################################################
#	database connection
########################################################################

#The following can be used as an argument to Bio::EnsEMBL::DBLoader->new( )
# to connect to the sequence database
use constant EnsemblLocator =>    'Bio::EnsEMBL::DBSQL::DBAdaptor/host=ServerE.cshl.org;port=1521;dbname=gramene;user=Sequence1;pass=PASSWORD;perlonlyfeatures=0;mapdbname=;driver=Oracle;debug=0';

use constant GMAPLocator => 'Bio::EnsEMBL::ExternalData::GMAPAdaptor/host=ServerE.cshl.org;port=1521;dbname=gramene;user=Sequence1;pass=PASSWORD;perlonlyfeatures=0;mapdbname=;driver=Oracle;debug=0';

#The following strings can be used to connect to the sequence database.
#They are the second and third arguments to $dbh = DBI->connect('dbi:Oracle:', , );
use constant SequenceDataSource => 'dbi:Oracle:';
use constant SequenceDBUser => q{Sequence1/PASSWORD@(DESCRIPTION=
  (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521))
  (CONNECT_DATA=(SID=gramene)))};
use constant SequenceDBPassword => '';	#because the password is already in the User

#For internal curator usage
#The following strings can be used to connect to the ontology database
# (which also has literature, protein, and mutant tables)
use constant CuratorDataSource => 'dbi:Oracle:';
use constant CuratorDBUser => q{CURATOR/PASSWORD@(DESCRIPTION= (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521)) (CONNECT_DATA=(SID=gramene)))};
use constant CuratorDBPassword => "";
use constant CuratorDBOptions => {
        PrintError  => 1, 
        RaiseError  => 1,
        LongReadLen => 3000,
        LongTruncOk => 1,				   
};


#The following strings can be used to connect to the ontology database
# (which also has literature and protein)
use constant OntologyDataSource => 'dbi:Oracle:';
use constant OntologyDBUser => q{ONTOLOGY/PASSWORD@(DESCRIPTION= (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521)) (CONNECT_DATA=(SID=gramene)))};
use constant OntologyDBPassword => "";
use constant OntologyDBOptions => {
        PrintError  => 1, 
        RaiseError  => 1,
        LongReadLen => 3000,
        LongTruncOk => 1,				   
};

#The following strings can be used to connect to the phenotype database
use constant MutantDataSource => 'dbi:Oracle:';
use constant MutantDBUser => q{MUTANT/PASSWORD@(DESCRIPTION= (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521)) (CONNECT_DATA=(SID=gramene)))};
use constant MutantDBPassword => "";
use constant MutantDBOptions => {
        PrintError  => 1, 
        RaiseError  => 1,
        LongReadLen => 3000,
        LongTruncOk => 1,				   
};

#The following strings can be used to connect to the comparative map database
use constant MapDataSource => 'dbi:Oracle:';
use constant MapDBUser => q{MAP/PASSWORD@(DESCRIPTION= (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521)) (CONNECT_DATA=(SID=gramene)))};
use constant MapDBPassword => "";
use constant MapDBOptions  => {
    RaiseError       => 1,
    FetchHashKeyName => 'NAME_lc',
    LongReadLen      => 3000,
    LongTruncOk      => 1,
};

###### And all over again for the 'Old' Databases
# repeat the things that don't change for people who are not using Oracle.
#
use constant OldEnsemblLocator =>    'Bio::EnsEMBL::DBSQL::DBAdaptor/host=ServerE.cshl.org;port=1521;dbname=gramene;user=Sequence;pass=PASSWORD;perlonlyfeatures=0;mapdbname=;driver=Oracle;debug=0';
use constant OldSequenceDataSource => 'dbi:Oracle:';
use constant OldSequenceDBUser => q{Sequence/PASSWORD@(DESCRIPTION=
  (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521))
  (CONNECT_DATA=(SID=gramene)))};
use constant OldSequenceDBPassword => '';	

use constant OldOntologyDataSource => 'dbi:Oracle:';
use constant OldOntologyDBUser => q{ONTOLOGY1/PASSWORD@(DESCRIPTION= (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521)) (CONNECT_DATA=(SID=gramene)))};
use constant OldOntologyDBPassword => "";
use constant OldOntologyDBOptions => {
        PrintError  => 1, 
        RaiseError  => 1,
        LongReadLen => 3000,
        LongTruncOk => 1,				   
};

use constant OldMapDataSource => 'dbi:Oracle:';
use constant OldMapDBUser => q{MAP1/PASSWORD@(DESCRIPTION= (ADDRESS=(PROTOCOL=TCP)(HOST=ServerE)(PORT=1521)) (CONNECT_DATA=(SID=gramene)))};
use constant OldMapDBPassword => "";
use constant OldMapDBOptions  => {
    RaiseError       => 1,
    FetchHashKeyName => 'NAME_lc',
    LongReadLen      => 3000,
    LongTruncOk      => 1,
};

########################################################################

#The following are the database names and passwords, to be used for 
#connecting through shell scripts or sqlplus or sqlloader.
use constant SequenceName=>'Sequence';
use constant SequencePass=>'PASSWORD';
use constant MapName=>'MAP';
use constant MapPass=>'PASSWORD';
use constant OntologyName=>'ONTOLOGY';
use constant OntologyPass=>'PASSWORD';
use constant CuratorName=>'CURATOR';
use constant CuratorPass=>'PASSWORD';
use constant MutantName=>'MUTANT ';
use constant MutantPass =>'PASSWORD';
#######################################################################
1;


=pod

=head1 NAME

Config.pm - gramene configuration module

=head1 SYNOPSIS

  use Config.pm;
  

=head1 DESCRIPTION


=cut

__END__

