package CSHL::ComparativeMaps::MarkerSearch;

#-----------------------------------------------------
# $Id: MarkerSearch.pm,v 1.4 2002/03/03 02:07:27 kclark Exp $
#
# File       : MarkerSearch.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/12/07
# Purpose    : search for markers by name
#-----------------------------------------------------

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.4 $)[-1];

use Apache::Constants;
use Apache::Request;
use Template;

use CSHL::ComparativeMaps::Constants;

use constant TEMPLATE => 'marker_search.tmpl';

sub handler {
    #
    # make a jazz noise here...
    #
    my $r       = shift;
    my $apr     = Apache::Request->new( $r );
    my $markers = $apr->param('markers') || '';

    my $page;
    if ( my $page_object = $apr->dir_config('PAGE_OBJECT') ) {
        $page = $page_object->new( $apr );
    }
    my $template_dir = $apr->dir_config('TEMPLATE_DIR') || TEMPLATE_DIR;
    my $t            = Template->new( { INCLUDE_PATH => $template_dir } );

    my $html;
    eval {
        my $results = $markers ? get_data(
            method  => 'marker_search',
            params  => { 
                markers  => $markers, 
                order_by => $apr->param('order_by'),
            },
        ) : undef;

        my $params         = { 
            apr            => $apr, 
            page           => $page,
            search_results => $results,
        };

        $t->process( TEMPLATE, $params, \$html ) or $html = $t->error;
    };

    if ( my $error = $@ ) {
        my $params = {
            error  => $error,
            page   => $page,
        };
        $t->process( ERROR_TEMPLATE, $params, \$html ) 
            or $html = $t->error;
    }

    $apr->content_type('text/html');
    $apr->send_http_header;
    $apr->print( $html );
    return OK;
}

1;

#-----------------------------------------------------
# Between two moments, bliss is ripe.
# William Blake
#-----------------------------------------------------

=pod

=head1 NAME

CSHL::ComparativeMaps::MarkerSearch

=head1 SYNOPSIS

In httpd.conf:

  <Location /maps/marker_search>
      SetHandler  perl-script
      PerlHandler CSHL::ComparativeMaps::MarkerSearch
  </Location>

=head1 DESCRIPTION

This module is a mod_perl handler for displaying the user interface
for searching for markers or loci.  Markers can be supplied separated
by whitespace, commas, colons, or semi-colons.  The seach results
include links which allow  a user to see the markers/loci on the maps. 

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1).

=cut
