package CSHL::ComparativeMaps::MapViewer;

#-----------------------------------------------------
# $Id: MapViewer.pm,v 1.17 2002/04/17 01:47:14 kclark Exp $
#
# File       : MapViewer.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/08/16
# Purpose    : show comparative maps
#-----------------------------------------------------

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.17 $)[-1];

use Apache;
use Apache::Request;
use Apache::Constants;
use GD;
use Data::Dumper;
use Template;

use CSHL::ComparativeMaps::Drawer;
use CSHL::ComparativeMaps::Constants;

use constant TEMPLATE => 'map.tmpl';

sub handler {
    #
    # Make a jazz noise here...
    #
    my $r           = shift;
    my $apr         = Apache::Request->new( $r->is_main ? $r : $r->main );
    my $preferences = $apr->pnotes('PREFERENCES');

    my $reference_map_study_id       = 
        $apr->param('reference_map_study_id')       || '';
    my $reference_map_id             = 
        $apr->param('reference_map_id')             || '';
    my $prev_reference_map_study_id  = 
        $apr->param('prev_reference_map_study_id')  || undef;
    my $prev_reference_map_id        = 
        $apr->param('prev_reference_map_id')        || undef;
    my $show_only_concordant_contigs = 
        $apr->param('show_only_concordant_contigs') || 0;
    my $start                        = 
        defined $apr->param('start') ? $apr->param('start') : undef;
    my $end                          = $apr->param('end');
    my $flip                         = $apr->param('flip') || '';

    #
    # User Preferences.
    #
    for my $field ( @{ +PREFERENCE_FIELDS } ) {
#        next if $apr->param( $field );
        $apr->param( $field, $preferences->{ $field } );
    }

    my $font_size    = $apr->param('font_size');
    my $image_height = $apr->param('image_height');
    my $image_type   = $apr->param('image_type');
    my $highlight    = $apr->param('highlight');

    #
    # Figure out the comparative map(s)
    #
    my @comparative_maps;
    my $number_of_maps = 2;
    for my $map_no ( 1..$number_of_maps ) {
        my $comparative_map = $apr->param("comparative_map$map_no") || '';

        my ( $comparative_map_field, $comparative_map_value ) = 
            split( /=/, $comparative_map );

        my $comparative_map_study_id = 
            $comparative_map_field eq 'map_study_id'
            ? $comparative_map_value : 0;

        my $comparative_map_id       = 
            $comparative_map_field eq 'genetic_map_id'
            ? $comparative_map_value : 0;

        if ( $comparative_map_study_id || $comparative_map_id ) {
            push @comparative_maps, {
                map_study_id   => $comparative_map_study_id,
                genetic_map_id => $comparative_map_id,
            };
        }

        $apr->param("comparative_map_field$map_no", $comparative_map_field );
        $apr->param("comparative_map_value$map_no", $comparative_map_value );
    }

    if ( defined $prev_reference_map_study_id &&
         ( $reference_map_study_id != $prev_reference_map_study_id )
    ) {
        $reference_map_id = '';
        $start            = undef;
        $end              = undef;
        $highlight        = '';
        @comparative_maps = ();
    }

    if ( defined $prev_reference_map_id &&
         ( $reference_map_id != $prev_reference_map_id )
    ) {
        @comparative_maps = ();
    }

    #
    # Create all the things we'll need for displaying the HTML
    #
    my $template_dir = $apr->dir_config('TEMPLATE_DIR') || TEMPLATE_DIR;
    my $t            = Template->new( { INCLUDE_PATH => $template_dir } );
    my $page;
    if ( my $page_object = $apr->dir_config('PAGE_OBJECT') ) {
        $page = $page_object->new( $apr );
    }
    my $html;

    #
    # Open an "eval" to catch any and all errors 
    # (poor man's exception handler).
    #
    eval {
        my ( $form_data, $err ) = get_data(
            apr    => $apr,
            method => 'map_viewer_form_data',
            params => { 
                reference_map_study_id => $reference_map_study_id,
                reference_map_id       => $reference_map_id,
                comparative_maps       => \@comparative_maps,
                start                  => $start,
                end                    => $end,
            }
        );

        die $err unless $form_data;

        $start                  = $form_data->{'start'};
        $end                    = $form_data->{'end'};
        $reference_map_study_id = $form_data->{'reference_map_study_id'};
        $reference_map_id       = $form_data->{'reference_map_id'};
        my $real_start          = $form_data->{'start'};
        my $real_end            = $form_data->{'end'};
        my $drawer;

        if ( $reference_map_id ) {
            $drawer = CSHL::ComparativeMaps::Drawer::Map->new(
                apr                          => $apr,
                reference_map_study_id       => $reference_map_study_id,
                reference_map_id             => $reference_map_id,
                start                        => $real_start,
                end                          => $real_end,
                highlight                    => $highlight,
                image_height                 => $image_height,
                flip                         => $flip,
                comparative_maps             => \@comparative_maps,
                image_type                   => $image_type,
                font_size                    => $font_size,
                show_only_concordant_contigs => $show_only_concordant_contigs,
            ) or die CSHL::ComparativeMaps::Drawer::Map->errstr;
            $drawer->layout;
        }

        $apr->param('reference_map_study_id',    $reference_map_study_id    );
        $apr->param('reference_map_id',          $reference_map_id          );
        $apr->param('start',                     $start                     );
        $apr->param('end',                       $end                       );
        $apr->param('highlight',                 $highlight                 );
        $apr->param('flip',                      $flip                      );
        $apr->param('image_height',              $image_height              );
        $apr->param('font_size',                 $font_size                 );
        $apr->param('image_type',                $image_type                );
        $apr->param('show_only_concordant_contigs ', 
                        $show_only_concordant_contigs   );

        my $params        = { 
            apr           => $apr, 
            form_data     => $form_data,
            page          => $page,
#            dump          => Dumper(defined $drawer ? $drawer->data : undef), 
            map_study_id1 => $form_data->{'map_study_id1'}  ||   '',
            map_title1    => $form_data->{'map_title1'}     ||   '',
            map_study_id2 => $form_data->{'map_study_id2'}  ||   '',
            map_title2    => $form_data->{'map_title2'}     ||   '',
        };

        if ( defined $drawer ) {
            $params->{'map_title'} = $drawer->map_title        ||    '';
            $params->{'map_areas'} = $drawer->image_map_areas  || undef;

            $apr->param('image_name', $drawer->image_name );
            $apr->param('map_height', $drawer->height     );
            $apr->param('map_width',  $drawer->width      );
        };

        $t->process( TEMPLATE, $params, \$html ) or $html = $t->error;
    };

    if ( my $error = $@ ) {
        my $params = {
            error => $error,
            page  => $page,
        };
        $t->process( ERROR_TEMPLATE, $params, \$html ) or $html = $t->error;
    }

    $r->content_type('text/html');
    $r->send_http_header;
    $r->print( $html );
    return OK;
}

1;

=pod

=head1 NAME

CSHL::ComparativeMaps::MapViewer

=head1 SYNOPSIS

In httpd.conf:

  <Location /maps/viewer>
      SetHandler  perl-script
      PerlHandler CSHL::ComparativeMaps::MapViewer
  </Location>

=head1 DESCRIPTION

This module is a mod_perl handler for displaying the user interface to
select and display comparative maps.

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1).

=cut

#-----------------------------------------------------
# The weak in courage is strong in cunning.
# William Blake
#-----------------------------------------------------
