package CSHL::ComparativeMaps::MapStudyInfo;

#-----------------------------------------------------
# $Id: MapStudyInfo.pm,v 1.3 2002/03/03 02:07:27 kclark Exp $
#
# File       : MapStudyInfo.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/12/10
# Purpose    : show complete info on map studies
#-----------------------------------------------------

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.3 $)[-1];

use Apache::Constants;
use Apache::Request;
use Template;

use CSHL::ComparativeMaps::Constants;

use constant TEMPLATE => 'map_study_info.tmpl';

sub handler {
    #
    # make a jazz noise here...
    #
    my $r             = shift;
    my $apr           = Apache::Request->new( $r->is_main ? $r : $r->main );
    my @map_study_ids = split( /,/, $apr->param('map_study_id') );
    my $template      = $apr->param('template') || TEMPLATE;
    my $template_dir  = $apr->dir_config('TEMPLATE_DIR') || TEMPLATE_DIR;
    my $t             = Template->new( { INCLUDE_PATH => $template_dir } );
    my $html;
    my $page;
    if ( my $page_object = $apr->dir_config('PAGE_OBJECT') ) {
        $page = $page_object->new( $apr );
    }

    eval {
        my $map_studies  = get_data(
            method => 'map_study_info',
            params => { map_study_ids => \@map_study_ids }
        );

        my %params      = ( 
            map_studies => $map_studies,
            page        => $page,
        );

        $t->process( $template, \%params, \$html ) 
            or $html = $t->error;
    };

    if ( my $error = $@ ) {
        my $params = {
            error  => $error,
            page   => $page,
        };
        $t->process( ERROR_TEMPLATE, $params, \$html ) or $html = $t->error;
    }

    $r->content_type('text/html');
    $r->send_http_header;
    $apr->print( $html );
    return OK;
}

1;

#-----------------------------------------------------
# Streets that follow like a tedious argument
# Of insidious intent
# To lead you to an overwhelming question...
# T. S. Eliot
#-----------------------------------------------------

=pod

=head1 NAME

CSHL::ComparativeMaps::MapStudyInfo

=head1 SYNOPSIS

In httpd.conf:

  <Location /maps/map_study_info>
      SetHandler  perl-script
      PerlHandler CSHL::ComparativeMaps::MapStudyInfo
  </Location>

=head1 DESCRIPTION

This module is a mod_perl handler for displaying all the information
in the database about one or more or all of the map studies.  If
supplied map_study_id's, expects a comma-separated list or one or more
ID's.  If none are supplied, then it will display all the map studies.

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1).

=cut

