package CSHL::ComparativeMaps::Help;

#-----------------------------------------------------
# $Id: Help.pm,v 1.4 2002/03/03 02:07:27 kclark Exp $
#
# File       : Help.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2002/01/15
# Purpose    : View help for comparative maps
#-----------------------------------------------------

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.4 $)[-1];

use Apache::Constants;
use Apache::Request;
use Template;

use CSHL::ComparativeMaps::Constants;

sub handler {
    #
    # make a jazz noise here...
    #
    my $r            = shift;
    my $apr          = Apache::Request->new( $r->is_main ? $r : $r->main );
    my $template_dir = $apr->dir_config('TEMPLATE_DIR') || TEMPLATE_DIR;
    my $t            = Template->new( { INCLUDE_PATH => $template_dir } );
    my $page;
    if ( my $page_object = $apr->dir_config('PAGE_OBJECT') ) {
        $page = $page_object->new( $apr );
    }

    my $html;
    $t->process( 'help.tmpl', { page => $page }, \$html ) 
        or $html = $t->error;

    $apr->content_type('text/html');
    $apr->send_http_header;
    $apr->print( $html );
    return OK;
}

1;

#-----------------------------------------------------
# For thy sweet love remembered such wealth brings
# That then I scorn to change my state with kings.
# William Shakespeare 
#-----------------------------------------------------

=head1 NAME

CSHL::ComparativeMaps::Help - View help for comparative maps

=head1 SYNOPSIS

In httpd.conf:

  <Location /maps/help>
      SetHandler  perl-script
      PerlHandler CSHL::ComparativeMaps::Help
  </Location>

=head1 DESCRIPTION

Displays the user help document for the maps. It's actually a minimal handler
that does little more than display an static HTML page. The reason the user
help isn't just static HTML is because it was deemed necessary to include the
help in other pages generated by Template Toolkit; therefore, the HTML was
moved into a template file in the "templates" directory so that Template
Toolkit could find and use it easily.

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1), Template.

=cut
