package CSHL::ComparativeMaps::ContigViewer;

#-----------------------------------------------------
# $Id: ContigViewer.pm,v 1.16 2002/04/17 01:47:13 kclark Exp $
#
# File       : ContigViewer.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/09/06
# Purpose    : show map of contig aside genetic map
#-----------------------------------------------------

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.16 $)[-1];

use Apache;
use Apache::Request;
use Apache::Constants;
use GD;
use Data::Dumper;
use Template;

use CSHL::ComparativeMaps::Drawer::Contig;
use CSHL::ComparativeMaps::Constants;

use constant TEMPLATE => 'contig.tmpl';

sub handler {
    #
    # make a jazz noise here...
    #
    my $r           = shift;
    my $apr         = Apache::Request->new( $r->is_main ? $r : $r->main );
    my $preferences = $apr->pnotes('PREFERENCES');

    my $physical_map_id = $apr->param('physical_map_id')   ||            0;
    my $genetic_map_id  = $apr->param('genetic_map_id')    ||            0; 
    my $action          = $apr->param('action')            ||           '';

#    my $font_size       = $apr->param('font_size')         ||           '';
#    my $image_type      = $apr->param('image_type')        ||           '';
#    my $image_height    = $apr->param('image_height')      ||           '';

    #
    # User Preferences.
    #
    for my $field ( @{ +PREFERENCE_FIELDS } ) {
        next if $apr->param( $field );
        $apr->param( $field, $preferences->{ $field } );
    }

    my $font_size    = $apr->param('font_size');
    my $image_height = $apr->param('image_height');
    my $image_type   = $apr->param('image_type');
    my $highlight    = $apr->param('highlight');

    my $template_dir    = $apr->dir_config('TEMPLATE_DIR') || TEMPLATE_DIR;
    my $t               = Template->new({ 
        INCLUDE_PATH => $template_dir,
        FILTERS      => {
            int      => sub { return int shift },
        }
    });

    #
    # Optional "page" object.
    #
    my $page;
    if ( my $page_object = $apr->dir_config('PAGE_OBJECT') ) {
        $page = $page_object->new( $apr );
    }

    my ( $output, $content_type );
    eval {
        my $drawer = CSHL::ComparativeMaps::Drawer::Contig->new(
            apr             => $apr,
            physical_map_id => $physical_map_id,
            genetic_map_id  => $genetic_map_id,
            font_size       => $font_size,
            image_height    => $image_height,
            image_type      => $image_type,
            highlight       => $highlight,
        ) or die CSHL::ComparativeMaps::Drawer::Contig->errstr;
        $drawer->layout;
        $apr->param( image_name   => $drawer->image_name );
        $apr->param( map_height   => $drawer->height     );
        $apr->param( map_width    => $drawer->width      );
        $apr->param( reference_map_study_id => 
            $apr->param('reference_map_study_id')  
        );
        $apr->param( reference_map_id => $apr->param('reference_map_id') );
        my $comparative_map =  $apr->param('comparative_map1');
           $comparative_map =~ s/=/%3D/;
        $apr->param( comparative_map1       => $comparative_map );
        $apr->param( start                  => $apr->param('start') );
        $apr->param( end                    => $apr->param('end') );

        my $map_areas = $drawer ? $drawer->image_map_areas : undef;
        my $contig    = $drawer->data( 2 );
        if ( $contig->{'map_name'} =~ m/(\d+)$/ ) {
            $contig->{'CUGI_contig_number'} = $1;
        }
        $contig->{'CUGI_species_name'} = lc $contig->{'species_common_name'};

        my $genetic_map = $drawer->data( 1 );
        my $params      = { 
            apr         => $apr, 
            contig      => $contig,
            genetic_map => $genetic_map,
#            dump        => Dumper( $contig ),
            map_areas   => $map_areas,
            page        => $page,
        };

        if ( $action eq 'data_dump' ) {
            $content_type = 'text/plain';
#            $output       = Dumper( $drawer->data_dump );
            $output       = $drawer->data_dump;
        }
        else {
            $t->process( TEMPLATE, $params, \$output ) or $output = $t->error;
        }
    };

    if ( my $error = $@ ) {
        my $params = { 
            error  => $error, 
            page   => $page,
        };
        $t->process( ERROR_TEMPLATE, $params, \$output ) or $output = $t->error;
    }

    $r->content_type( $content_type || 'text/html');
    $r->send_http_header;
    $r->print( $output );
    return OK;
}

1;

=pod

=head1 NAME

CSHL::ComparativeMaps::ContigViewer

=head1 SYNOPSIS

In httpd.conf:

  <Location /maps/contig>
      SetHandler  perl-script
      PerlHandler CSHL::ComparativeMaps::ContigViewer
  </Location>

=head1 DESCRIPTION

This module is a mod_perl handler for displaying the user interface to
view individual contigs beside a reference genetic map.

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1).

=cut

#-----------------------------------------------------
# The eyes of fire, the nostrils of air,
# The mouth of water, the beard of earth.
# William Blake
#-----------------------------------------------------
