package CSHL::ComparativeMaps::Admin::BaseObject;

#-----------------------------------------------------
# $Id: BaseObject.pm,v 1.4 2002/04/18 16:26:48 kclark Exp $
#
# File       : BaseObject.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/12/18
# Purpose    : base object for Admin::* modules
#-----------------------------------------------------

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.4 $)[-1];

use CSHL::Config;
use CSHL::ComparativeMaps::Constants;

sub new {
    #
    # Make a jazz noise here...
    #
    my $class = shift;
    my $self  = { @_};
    bless $self, $class;
    return $self;
}

sub db {
    my $self = shift;
    unless ( defined $self->{'db'} ) {
        $self->{'db'} = DBI->connect( 
            MapDataSource,
            MapDBUser,
            MapDBPassword,
            MapDBOptions,
       );
    }
    return $self->{'db'};
}

sub err_out {
    my $self = shift;
    $self->{'error'} = shift if @_;
    return undef;
}

sub error {
    return shift->{'error'};
}

sub be_quiet {
    my $self = shift;
    $self->{'be_quiet'} = shift if @_;
    return $self->{'be_quiet'};
}

sub Print {
    my $self = shift;
    return if $self->be_quiet;
    print @_;
}

1;

#-----------------------------------------------------
# What is now proved was once, only imagin'd.
# William Blake
#-----------------------------------------------------

=head1 NAME

BaseObject.pm - base object for Admin::* modules

=head1 SYNOPSIS

  use BaseObject.pm;
  blah blah blah

=head1 DESCRIPTION

Blah blah blah.

=head1 AUTHOR

Ken Y. Clark, kclark@logsoft.com

=head1 SEE ALSO

perl(1).

=cut
