package Apache::Putback;

# Like Apache::File, but provides a putback() call to put a line of
# text back into the buffer. 
# methods:
#         readline()       return a line of text
#         putback($line)  put a line of text back 

use strict;
use Apache::File;

sub new {
    my $class = shift;
    my $fh = Apache::File->new(@_) || return;
    return bless { 'fh'=>$fh,'lines'=>[] },$class;
}

sub readline {
    my $self = shift;
    return pop @{$self->{'lines'}} if @{$self->{'lines'}};
    my $fh = $self->{'fh'} || return;
    return scalar <$fh>;
}

sub putback {
    my $self = shift;
    push @{$self->{'lines'}},$_[0];
}


1;
