package Apache::Mail;
# file Apache/Mail.pm

use strict;
use vars qw(@ISA $VERSION);
use Apache::Constants qw(:common);
use Apache::File;
use CSHL::Config;
use GramenePage;
use LWP::UserAgent();

@ISA = qw(LWP::UserAgent);
$VERSION = '1.00';

my $UA = __PACKAGE__->new;
$UA->agent(join "/",__PACKAGE__, $VERSION);

sub handler {
    my $r = shift;

    
    $r->content_type ( 'text/html') unless $r->content_type;
    return DECLINED unless $r->content_type eq 'text/html';

    my $them=$r->get_remote_host();
    my $naked= index($them ,OtherGrameneServerName)>=0 || ($them eq OtherGrameneServerIP) ;

#    print STDERR "grh:$them\n$naked\n";

    if( ! -e $r->finfo && !$naked) { #try to get from other system
#	print STDERR "want ",$r->uri,"\n";
        my $request=HTTP::Request->new($r->method, "http://".OtherGrameneServerName.$r->uri);

        $r->headers_in->do(   sub { $request->header(@_); }   );

        if($r->method eq 'POST') {
	    my $len=$r->header_in('Content-length');
	    my $buf;
	    $r->read($buf,$len);
	    $request->content($buf);
	}

        my $response=$UA->request($request);
#	if($response->is_error) {
#	    print STDERR "response error code=",$response->code,"\n";	#,"  html=",response->error_as_HTML,"\n";
#	} else {
#	    print STDERR "response no error\n"
#	}
	$r->content_type($response->header('Content-type'));

	$r->status($response->code);
	$r->status_line(join " ", $response->code, $response->message);
	$response->scan( sub { $r->header_out(@_); }  );

	if($r->header_only) {
	    $r->send_http_header();
	    return OK;
	}

	my $content=\$response->content;

#	print STDERR "Moxy content length=",length($$content),"\n";

	$r->content_type ( 'text/html' ) unless $$content;

	if( $r->content_type eq 'text/html' ) {	#Now we can have fun

#	    print STDERR "Moxy fun\n";
	    my $page = GramenePage->new($r);
	    my $ssl=$page->stylesheet_link;
	    my $sb=$page->start_body;
	    my $eb=$page->end_body('');

	    $$content =~ s!(</head)!$ssl$1!is;
	    $$content =~ s!<body[^>]*>!$sb!is;
	    $$content =~ s!</body.*!$eb!is; #since end_body includes </html>
	}

	$r->send_http_header();
	$r->print ($$content || $response->error_as_HTML);

	return OK;

    }
    my $fh = Apache::File->new($r->filename) || return DECLINED;

	

    my $page = $naked ? undef : GramenePage->new($r) ;

    my $insert=$r->filename;
    $insert=~ s![^/]*$!top_insert.html!;
    my $ifh;
    if ( ( -r $insert) &&  ($ifh=Apache::File->new($insert)) ) {
      $insert=join '',<$ifh>;
    } else {
      $insert='';
    }


    # This code handles the "If-Modified-Since" code.
    $r->update_mtime($page->modified) if $page;
    $r->set_last_modified;
    my $rc = $r->meets_conditions;
    return $rc unless $rc == OK;

    $r->send_http_header;
    return OK if $r->header_only;

    my ($header_found,$body_found,$body_ended);
    my $footer_text = qq(<p align="left">Last modified: ).localtime((stat($r->filename))[9]).qq(</p>);

    while (<$fh>) {

      if (m!</head!i) {
	  $r->print($page->stylesheet_link) if $page;
	  $r->print($_);
	  $header_found++;
      }

      elsif (m!<body(.*)!i) {
	if($page) {
	    $r->print($page->stylesheet,"</head>") unless $header_found;
	    $r->print($page->start_body) ;
	} else {
	    $r->print($_);
	}
	$r->print($insert);
	$body_found++;
      }

      elsif (m!</body!i) {
	if($page) {
	    $r->print($page->end_body($footer_text)) if $page;
	} else {
	    $r->print($_);
	}
	$body_ended++;
      }

      elsif (m!<h\d+>!i && !$body_found) { # oops, in body
	$r->print($page->stylesheet_link) if $page;
	$r->print($page->start_body) if $page;
	$r->print($_);
	$header_found++;
	$body_found++;
      }

      else {
    #	s!http://probe\.nalusda\.gov:8000/otherdocs/rgn/rgn\d+/!!g;
	print $_;
      }

    }

    $r->print($page->end_body($footer_text)) unless $body_ended or !$page;
    return OK;
}

1;
__END__




